/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.provider.IOHelper;
import org.everrest.core.provider.EntityProvider;
import org.everrest.core.util.NoSyncByteArrayOutputStream;

@Provider
public class ByteEntityProvider
implements EntityProvider<byte[]> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == byte[].class;
    }

    public byte[] readFrom(Class<byte[]> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String contentLength = (String)httpHeaders.getFirst((Object)"Content-Length");
        int length = 0;
        if (contentLength != null) {
            try {
                length = Integer.parseInt(contentLength);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        NoSyncByteArrayOutputStream out = length > 0 ? new NoSyncByteArrayOutputStream(length) : new NoSyncByteArrayOutputStream();
        IOHelper.write(entityStream, out);
        return ((ByteArrayOutputStream)out).toByteArray();
    }

    public long getSize(byte[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.length;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == byte[].class;
    }

    public void writeTo(byte[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        entityStream.write(t);
    }
}

