/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.everrest.core.impl.provider.json.ArrayValue;
import org.everrest.core.impl.provider.json.BooleanValue;
import org.everrest.core.impl.provider.json.DoubleValue;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.LongValue;
import org.everrest.core.impl.provider.json.NullValue;
import org.everrest.core.impl.provider.json.ObjectValue;
import org.everrest.core.impl.provider.json.StringValue;

public class JsonGenerator {
    static final Collection<String> SKIP_METHODS = new HashSet<String>();

    public static JsonValue createJsonArray(Collection<?> collection) throws JsonException {
        return JsonGenerator.createJsonValue(collection);
    }

    public static JsonValue createJsonArray(Object array) throws JsonException {
        if (array == null) {
            return new NullValue();
        }
        JsonUtils.Types t = JsonUtils.getType(array);
        if (t == JsonUtils.Types.ARRAY_BOOLEAN || t == JsonUtils.Types.ARRAY_BYTE || t == JsonUtils.Types.ARRAY_SHORT || t == JsonUtils.Types.ARRAY_INT || t == JsonUtils.Types.ARRAY_LONG || t == JsonUtils.Types.ARRAY_FLOAT || t == JsonUtils.Types.ARRAY_DOUBLE || t == JsonUtils.Types.ARRAY_CHAR || t == JsonUtils.Types.ARRAY_STRING || t == JsonUtils.Types.ARRAY_OBJECT) {
            return JsonGenerator.createJsonValue(array);
        }
        throw new JsonException("Invalid argument, must be array.");
    }

    public static JsonValue createJsonObjectFromMap(Map<String, ?> map) throws JsonException {
        return JsonGenerator.createJsonValue(map);
    }

    public JsonValue createJsonObjectFromString(String s) throws JsonException {
        JsonParser parser = new JsonParser();
        parser.parse(new StringReader(s));
        return parser.getJsonObject();
    }

    public static JsonValue createJsonObject(Object object) throws JsonException {
        Class<?> clazz = object.getClass();
        Method[] methods = clazz.getMethods();
        Set<String> transientFieldNames = JsonUtils.getTransientFields(clazz);
        ObjectValue jsonRootValue = new ObjectValue();
        for (Method method : methods) {
            String methodName = method.getName();
            String key = null;
            if (!SKIP_METHODS.contains(methodName) && method.getParameterTypes().length == 0) {
                if (methodName.startsWith("get") && methodName.length() > 3) {
                    key = methodName.substring(3);
                } else if (methodName.startsWith("is") && methodName.length() > 2 && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                    key = methodName.substring(2);
                }
            }
            if (key == null) continue;
            String string = key = key.length() > 1 ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : key.toLowerCase();
            if (transientFieldNames.contains(key)) continue;
            try {
                Object invokeResult = method.invoke(object, new Object[0]);
                if (JsonUtils.getType(invokeResult) != null) {
                    ((JsonValue)jsonRootValue).addElement(key, JsonGenerator.createJsonValue(invokeResult));
                    continue;
                }
                ((JsonValue)jsonRootValue).addElement(key, JsonGenerator.createJsonObject(invokeResult));
            }
            catch (InvocationTargetException e) {
                throw new JsonException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new JsonException(e.getMessage(), e);
            }
        }
        return jsonRootValue;
    }

    private static JsonValue createJsonValue(Object object) throws JsonException {
        JsonUtils.Types type = JsonUtils.getType(object);
        switch (type) {
            case NULL: {
                return new NullValue();
            }
            case BOOLEAN: {
                return new BooleanValue((Boolean)object);
            }
            case BYTE: {
                return new LongValue(((Byte)object).byteValue());
            }
            case SHORT: {
                return new LongValue(((Short)object).shortValue());
            }
            case INT: {
                return new LongValue(((Integer)object).intValue());
            }
            case LONG: {
                return new LongValue((Long)object);
            }
            case FLOAT: {
                return new DoubleValue(((Float)object).floatValue());
            }
            case DOUBLE: {
                return new DoubleValue((Double)object);
            }
            case CHAR: {
                return new StringValue(Character.toString(((Character)object).charValue()));
            }
            case STRING: {
                return new StringValue((String)object);
            }
            case ENUM: {
                return new StringValue(((Enum)object).name());
            }
            case ARRAY_BOOLEAN: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new BooleanValue(Array.getBoolean(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_BYTE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getByte(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_SHORT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getShort(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_INT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getInt(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_LONG: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getLong(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_FLOAT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getFloat(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_DOUBLE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getDouble(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_CHAR: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue(Character.toString(Array.getChar(object, i))));
                }
                return jsonArray;
            }
            case ARRAY_STRING: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue((String)Array.get(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_OBJECT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object el = Array.get(object, i);
                    if (JsonUtils.getType(el) != null) {
                        ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonValue(el));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonObject(el));
                }
                return jsonArray;
            }
            case COLLECTION: {
                ArrayValue jsonArray = new ArrayValue();
                ArrayList list = new ArrayList((Collection)object);
                for (Object o : list) {
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonObject(o));
                }
                return jsonArray;
            }
            case MAP: {
                ObjectValue jsonObject = new ObjectValue();
                HashMap map = new HashMap((Map)object);
                Set keys = map.keySet();
                for (String k : keys) {
                    Object o = map.get(k);
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonObject).addElement(k, JsonGenerator.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonObject).addElement(k, JsonGenerator.createJsonObject(o));
                }
                return jsonObject;
            }
        }
        return null;
    }

    static {
        SKIP_METHODS.add("getClass");
        SKIP_METHODS.add("getMetaClass");
    }
}

