/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.util.Logger;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;

public class EverrestServletContextInitializer {
    public static final String EVERREST_SCAN_COMPONENTS = "org.everrest.scan.components";
    public static final String EVERREST_SCAN_SKIP_PACKAGES = "org.everrest.scan.skip.packages";
    public static final String JAXRS_APPLICATION = "javax.ws.rs.Application";
    private static final Logger LOG = Logger.getLogger(EverrestServletContextInitializer.class);
    protected final ServletContext sctx;

    public EverrestServletContextInitializer(ServletContext sctx) {
        this.sctx = sctx;
    }

    public Application getApplication() {
        Application application = null;
        String applicationFQN = this.getParameter(JAXRS_APPLICATION);
        boolean scan = false;
        String scanParameter = this.getParameter(EVERREST_SCAN_COMPONENTS);
        if (scanParameter != null) {
            scan = Boolean.parseBoolean(scanParameter);
        }
        if (applicationFQN != null) {
            if (scan) {
                String msg = "Scan of JAX-RS components is disabled cause to specified 'javax.ws.rs.Application'.";
                LOG.warn(msg);
            }
            try {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(applicationFQN.trim());
                application = (Application)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (scan) {
            try {
                URL classes = WarUrlFinder.findWebInfClassesPath((ServletContext)this.sctx);
                URL[] libs = WarUrlFinder.findWebInfLibClasspaths((ServletContext)this.sctx);
                AnnotationDB annotationDB = new AnnotationDB();
                ArrayList<String> skip = new ArrayList<String>();
                String sskip = this.sctx.getInitParameter(EVERREST_SCAN_SKIP_PACKAGES);
                if (sskip != null) {
                    for (String s : sskip.split(",")) {
                        skip.add(s.trim());
                    }
                }
                skip.add("org.everrest.core");
                skip.add("javax.ws.rs");
                annotationDB.setIgnoredPackages(skip.toArray(new String[skip.size()]));
                annotationDB.setScanFieldAnnotations(false);
                annotationDB.setScanMethodAnnotations(false);
                annotationDB.setScanParameterAnnotations(false);
                if (classes != null) {
                    annotationDB.scanArchives(new URL[]{classes});
                }
                annotationDB.scanArchives(libs);
                final HashSet scanned = new HashSet();
                Map results = annotationDB.getAnnotationIndex();
                for (String annotation : new String[]{Path.class.getName(), Provider.class.getName(), Filter.class.getName()}) {
                    if (results.get(annotation) == null) continue;
                    for (String fqn : (Set)results.get(annotation)) {
                        try {
                            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(fqn);
                            if (cl.isInterface() || Modifier.isAbstract(cl.getModifiers())) {
                                LOG.info("Skip abstract class or interface " + fqn);
                                continue;
                            }
                            scanned.add(cl);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                application = new Application(){

                    public Set<Class<?>> getClasses() {
                        return scanned;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return application;
    }

    public EverrestConfiguration getConfiguration() {
        String securityParameter;
        String normalizeUriParameter;
        EverrestConfiguration config = new EverrestConfiguration();
        String httpMethodOverrideParameter = this.getParameter("org.everrest.http.method.override");
        if (httpMethodOverrideParameter != null) {
            config.setHttpMethodOverride(Boolean.parseBoolean(httpMethodOverrideParameter));
        }
        if ((normalizeUriParameter = this.getParameter("org.everrest.normalize.uri")) != null) {
            config.setNormalizeUri(Boolean.parseBoolean(normalizeUriParameter));
        }
        if ((securityParameter = this.getParameter("org.everrest.security")) != null) {
            config.setCheckSecurity(Boolean.parseBoolean(securityParameter));
        }
        return config;
    }

    public String getParameter(String name) {
        return this.sctx.getInitParameter(name);
    }
}

