/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.RequestHandler;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.tools.DummyContainerResponseWriter;
import org.everrest.core.tools.SecurityContextRequest;

public class ResourceLauncher {
    private final RequestHandler requestHandler;

    public ResourceLauncher(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, ContainerResponseWriter writer, EnvironmentContext env) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
            headers.put("Content-Length", Arrays.asList(Integer.toString(data.length)));
        }
        if (env == null) {
            env = new EnvironmentContext();
        }
        EnvironmentContext.setCurrent(env);
        if (writer == null) {
            writer = new DummyContainerResponseWriter();
        }
        SecurityContext sctx = (SecurityContext)env.get(SecurityContext.class);
        SecurityContextRequest request = new SecurityContextRequest(method, new URI(requestURI), new URI(baseURI), in, new InputHeadersMap(headers), sctx);
        ContainerResponse response = new ContainerResponse(writer);
        this.requestHandler.handleRequest(request, response);
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, EnvironmentContext env) throws Exception {
        return this.service(method, requestURI, baseURI, headers, data, new DummyContainerResponseWriter(), env);
    }
}

