/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.everrest.core.impl.provider.ext;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;

/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: InMemoryItemFactory.java 80 2010-10-27 10:15:58Z andrew00x $
 */
class InMemoryItemFactory implements FileItemFactory
{

   private final int maxSize;

   public InMemoryItemFactory(int maxSize)
   {
      this.maxSize = maxSize;
   }

   /**
    * {@inheritDoc}
    */
   public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName)
   {
      return new InMemoryFileItem(contentType, fieldName, isFormField, fileName, maxSize);
   }

}
