/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.everrest.core.DependencyNameDetector;
import org.everrest.core.DependencySupplier;
import org.everrest.core.FieldInjector;
import org.everrest.core.Parameter;

public abstract class BaseDependencySupplier
implements DependencySupplier {
    protected final Class<? extends Annotation> injectAnnotationClass;
    protected final DependencyNameDetector nameDetector;

    public BaseDependencySupplier(Class<? extends Annotation> injectAnnotationClass, DependencyNameDetector nameDetector) {
        if (injectAnnotationClass == null) {
            throw new IllegalArgumentException("Inject annotation class may not be null. ");
        }
        this.injectAnnotationClass = injectAnnotationClass;
        this.nameDetector = nameDetector;
    }

    public BaseDependencySupplier(Class<? extends Annotation> injectAnnotationClass) {
        if (injectAnnotationClass == null) {
            throw new IllegalArgumentException("Inject annotation class may not be null. ");
        }
        this.injectAnnotationClass = injectAnnotationClass;
        this.nameDetector = null;
    }

    public BaseDependencySupplier() {
        this(Inject.class, new DependencyNameDetector(){

            @Override
            public String getName(Parameter parameter) {
                for (Annotation a : parameter.getAnnotations()) {
                    String name;
                    if (!Named.class.isInstance(a) || (name = ((Named)a).value()).isEmpty()) continue;
                    return name;
                }
                return null;
            }
        });
    }

    @Override
    public final Object getComponent(Parameter parameter) {
        boolean injectable = false;
        if (parameter instanceof FieldInjector) {
            for (Annotation a : parameter.getAnnotations()) {
                if (!this.injectAnnotationClass.isInstance(a)) continue;
                injectable = true;
                break;
            }
        } else {
            injectable = true;
        }
        if (injectable) {
            String name;
            String string = name = this.nameDetector != null ? this.nameDetector.getName(parameter) : null;
            if (name != null) {
                return this.getComponentByName(name);
            }
            Class<?> parameterClass = parameter.getParameterClass();
            if (this.isProvider(parameterClass)) {
                return this.getProvider(parameter.getGenericType());
            }
            return this.getComponent(parameterClass);
        }
        return null;
    }

    public Object getComponentByName(String name) {
        return null;
    }

    protected final boolean isProvider(Class<?> clazz) {
        return Provider.class == clazz;
    }

    public Provider<?> getProvider(Type providerType) {
        Class componentType;
        if (!(providerType instanceof ParameterizedType)) {
            throw new RuntimeException("Cannot inject provider without type parameter. ");
        }
        Type actualType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        if (actualType instanceof Class) {
            componentType = (Class)actualType;
        } else if (actualType instanceof ParameterizedType) {
            componentType = (Class)((ParameterizedType)actualType).getRawType();
        } else {
            throw new RuntimeException("Unsupported type " + actualType + ". ");
        }
        final Class fcomponentType = componentType;
        return new Provider<Object>(){

            public Object get() {
                return BaseDependencySupplier.this.getComponent(fcomponentType);
            }
        };
    }
}

