/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.everrest.core.DependencySupplier;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.Lifecycle;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.method.MethodInvokerDecoratorFactory;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.util.Logger;
import org.everrest.core.util.Tracer;

public class RequestHandlerImpl
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(RequestHandlerImpl.class);
    private static final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final RequestDispatcher dispatcher;
    private final DependencySupplier dependencySupplier;
    private final ProviderBinder providers;
    private final boolean normalizeUriFeature;
    private final boolean httpMethodOverrideFeature;
    private MethodInvokerDecoratorFactory methodInvokerDecoratorFactory;

    public static String getProperty(String name) {
        return properties.get(name);
    }

    public static void setProperty(String name, String value) {
        if (value == null) {
            properties.remove(name);
        } else {
            properties.put(name, value);
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, ProviderBinder providers, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this.dispatcher = dispatcher;
        this.dependencySupplier = dependencySupplier;
        ProviderBinder providerBinder = this.providers = providers == null ? ProviderBinder.getInstance() : providers;
        if (config == null) {
            config = new EverrestConfiguration();
        }
        this.httpMethodOverrideFeature = config.isHttpMethodOverride();
        this.normalizeUriFeature = config.isNormalizeUri();
        ServiceLoader<MethodInvokerDecoratorFactory> s = ServiceLoader.load(MethodInvokerDecoratorFactory.class);
        Iterator<MethodInvokerDecoratorFactory> iterator = s.iterator();
        if (iterator.hasNext()) {
            this.methodInvokerDecoratorFactory = iterator.next();
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this(dispatcher, null, dependencySupplier, config);
    }

    public RequestHandlerImpl(ResourceBinder resources, DependencySupplier dependencySupplier) {
        this(new RequestDispatcher(resources), null, dependencySupplier, new EverrestConfiguration());
    }

    public RequestHandlerImpl(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this(new RequestDispatcher(resources), providers, dependencySupplier, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws UnhandledException, IOException {
        ApplicationContextImpl context = null;
        try {
            String method;
            context = new ApplicationContextImpl(request, response, this.providers, this.methodInvokerDecoratorFactory);
            context.getProperties().putAll(properties);
            context.setDependencySupplier(this.dependencySupplier);
            ((Lifecycle)context).start();
            ApplicationContextImpl.setCurrent(context);
            if (this.normalizeUriFeature) {
                request.setUris(UriComponent.normalize(request.getRequestUri()), request.getBaseUri());
            }
            if (this.httpMethodOverrideFeature && (method = (String)request.getRequestHeaders().getFirst((Object)"X-HTTP-Method-Override")) != null) {
                if (Tracer.isTracingEnabled()) {
                    Tracer.trace("Override HTTP method from \"X-HTTP-Method-Override\" header " + request.getMethod() + " => " + method);
                }
                request.setMethod(method);
            }
            try {
                String jaxrsHeader;
                for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getRequestFilters(context.getPath())) {
                    ((RequestFilter)factory.getInstance(context)).doFilter(request);
                }
                this.dispatcher.dispatch(request, response);
                if (response.getHttpHeaders().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(response.getStatus())) != null) {
                    response.getHttpHeaders().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                }
                for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getResponseFilters(context.getPath())) {
                    ((ResponseFilter)factory.getInstance(context)).doFilter(response);
                }
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    String jaxrsHeader;
                    Response errorResponse = ((WebApplicationException)e).getResponse();
                    int errorStatus = errorResponse.getStatus();
                    Throwable cause = e.getCause();
                    if (errorStatus < 500) {
                        if (LOG.isDebugEnabled() && cause != null) {
                            LOG.debug("WebApplicationException occurs.", cause);
                        }
                    } else if (cause != null) {
                        LOG.error("WebApplicationException occurs.", cause);
                    }
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace("WebApplicationException occurs, cause = (" + cause + ")");
                    }
                    ExceptionMapper<WebApplicationException> exceptionMapper = context.getProviders().getExceptionMapper(WebApplicationException.class);
                    if (errorResponse.getEntity() == null) {
                        if (exceptionMapper != null) {
                            if (Tracer.isTracingEnabled()) {
                                Tracer.trace("Found ExceptionMapper for WebApplicationException = (" + exceptionMapper + ")");
                            }
                            errorResponse = exceptionMapper.toResponse((Throwable)e);
                        } else if (e.getMessage() != null) {
                            errorResponse = this.createErrorResponse(errorStatus, e.getMessage());
                        }
                    } else if (errorResponse.getMetadata().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(errorStatus)) != null) {
                        errorResponse.getMetadata().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                    }
                    response.setResponse(errorResponse);
                }
                if (e instanceof InternalException) {
                    Throwable cause = e.getCause();
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace("InternalException occurs, cause = (" + cause + ")");
                    }
                    Class<?> causeClazz = cause.getClass();
                    ExceptionMapper<?> exceptionMapper = context.getProviders().getExceptionMapper(causeClazz);
                    while (causeClazz != null && exceptionMapper == null) {
                        exceptionMapper = context.getProviders().getExceptionMapper(causeClazz);
                        if (exceptionMapper != null) continue;
                        causeClazz = causeClazz.getSuperclass();
                    }
                    if (exceptionMapper != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("InternalException occurs.", cause);
                        }
                        if (Tracer.isTracingEnabled()) {
                            Tracer.trace("Found ExceptionMapper for " + cause.getClass() + " = (" + exceptionMapper + ")");
                        }
                        response.setResponse(exceptionMapper.toResponse(cause));
                    }
                    LOG.error("InternalException occurs.", cause);
                    throw new UnhandledException(e.getCause());
                }
                throw new UnhandledException(e);
            }
            response.writeResponse();
        }
        finally {
            try {
                if (context != null) {
                    ((Lifecycle)context).stop();
                }
            }
            finally {
                ApplicationContextImpl.setCurrent(null);
            }
        }
    }

    private Response createErrorResponse(int status, String message) {
        Response.ResponseBuilder responseBuilder = Response.status((int)status);
        responseBuilder.entity((Object)message).type("text/plain");
        String jaxrsHeader = this.getJaxrsHeader(status);
        if (jaxrsHeader != null) {
            responseBuilder.header("JAXRS-Body-Provided", (Object)jaxrsHeader);
        }
        return responseBuilder.build();
    }

    private String getJaxrsHeader(int status) {
        if (status >= 400) {
            return "Error-Message";
        }
        return null;
    }
}

