/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private List<Locale> languages = new ArrayList<Locale>();
    private List<String> encodings = new ArrayList<String>();
    private List<MediaType> mediatypes = new ArrayList<MediaType>();
    private List<Variant> variants;

    public Variant.VariantListBuilder add() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        Iterator<MediaType> mediatypesIterator = this.mediatypes.iterator();
        do {
            MediaType mediaType = mediatypesIterator.hasNext() ? mediatypesIterator.next() : null;
            Iterator<Locale> languagesIterator = this.languages.iterator();
            do {
                Locale language = languagesIterator.hasNext() ? languagesIterator.next() : null;
                Iterator<String> encodingsIterator = this.encodings.iterator();
                do {
                    String encoding = encodingsIterator.hasNext() ? encodingsIterator.next() : null;
                    this.variants.add(new Variant(mediaType, language, encoding));
                } while (encodingsIterator.hasNext());
            } while (languagesIterator.hasNext());
        } while (mediatypesIterator.hasNext());
        this.clearAll();
        return this;
    }

    public List<Variant> build() {
        return this.variants == null ? (this.variants = new ArrayList<Variant>()) : this.variants;
    }

    public Variant.VariantListBuilder encodings(String ... encs) {
        Collections.addAll(this.encodings, encs);
        return this;
    }

    public Variant.VariantListBuilder languages(Locale ... langs) {
        Collections.addAll(this.languages, langs);
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        Collections.addAll(this.mediatypes, mediaTypes);
        return this;
    }

    private void clearAll() {
        this.mediatypes.clear();
        this.languages.clear();
        this.encodings.clear();
    }
}

