/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobRejectedException;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.util.Logger;

@Provider
public class AsynchronousJobPool
implements ContextResolver<AsynchronousJobPool> {
    private static final Logger LOG = Logger.getLogger(AsynchronousJobPool.class);
    private static final AtomicLong jobNumber = new AtomicLong(1L);
    private final int jobTimeout;
    private final int maxCacheSize;
    private final ExecutorService pool;
    private final Map<String, AsynchronousJob> jobs;

    public AsynchronousJobPool(EverrestConfiguration config) {
        if (config == null) {
            config = new EverrestConfiguration();
        }
        int poolSize = config.getAsynchronousPoolSize();
        int queueSize = config.getAsynchronousQueueSize();
        this.maxCacheSize = config.getAsynchronousCacheSize();
        this.jobTimeout = config.getAsynchronousJobTimeout();
        this.pool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ManyJobsPolicy(new ThreadPoolExecutor.AbortPolicy()));
        this.jobs = Collections.synchronizedMap(new LinkedHashMap<String, AsynchronousJob>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, AsynchronousJob> eldest) {
                AsynchronousJob job = eldest.getValue();
                if (this.size() > AsynchronousJobPool.this.maxCacheSize || job.getExpirationDate() < System.currentTimeMillis()) {
                    job.cancel(true);
                    return true;
                }
                return false;
            }
        });
    }

    public AsynchronousJobPool getContext(Class<?> type) {
        return this;
    }

    public String addJob(Object resource, ResourceMethodDescriptor resourceMethod, Object[] params) throws AsynchronousJobRejectedException {
        AsynchronousJob job = new AsynchronousJob(this.newCallable(resource, resourceMethod.getMethod(), params), Long.toString(jobNumber.getAndIncrement()), this.jobTimeout, TimeUnit.MINUTES, resourceMethod);
        try {
            this.pool.execute(job);
        }
        catch (RejectedExecutionException e) {
            throw new AsynchronousJobRejectedException(e.getMessage());
        }
        String jobId = job.getJobId();
        this.jobs.put(jobId, job);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add asynchronous job, ID " + jobId);
        }
        return jobId;
    }

    protected Callable<Object> newCallable(final Object resource, final Method method, final Object[] params) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return method.invoke(resource, params);
            }
        };
    }

    public AsynchronousJob getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    public boolean removeJob(String jobId, boolean stopJob) {
        AsynchronousJob job = this.jobs.remove(jobId);
        if (job != null) {
            if (stopJob) {
                job.cancel(true);
            }
            return true;
        }
        return false;
    }

    @PreDestroy
    public void stop() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static class ManyJobsPolicy
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public ManyJobsPolicy(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.getPoolSize() >= executor.getCorePoolSize()) {
                throw new RejectedExecutionException("Can't accept new asynchronous request. Too many asynchronous jobs in progress. ");
            }
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

