/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.everrest.core.impl.header.AcceptMediaType;

public final class MediaTypeHelper {
    public static final String DEFAULT = "*/*";
    public static final MediaType DEFAULT_TYPE = new MediaType("*", "*");
    public static final List<MediaType> DEFAULT_TYPE_LIST = Collections.singletonList(DEFAULT_TYPE);
    public static final String WADL = "application/vnd.sun.wadl+xml";
    public static final MediaType WADL_TYPE = new MediaType("application", "vnd.sun.wadl+xml");
    public static final String EXT_SUFFIX_SUBTYPE = "+*";
    public static final String EXT_PREFIX_SUBTYPE = "*+";
    public static final Pattern EXT_SUBTYPE_PATTERN = Pattern.compile("([^\\+]+)\\+(.+)");
    public static final Pattern EXT_SUFFIX_SUBTYPE_PATTERN = Pattern.compile("([^\\+]+)\\+\\*");
    public static final Pattern EXT_PREFIX_SUBTYPE_PATTERN = Pattern.compile("\\*\\+(.+)");
    public static final Comparator<MediaType> MEDIA_TYPE_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType mediaType1, MediaType mediaType2) {
            String type1 = mediaType1.getType();
            String subType1 = mediaType1.getSubtype();
            String type2 = mediaType2.getType();
            String subType2 = mediaType2.getSubtype();
            if (type1.equals("*") && !type2.equals("*")) {
                return 1;
            }
            if (!type1.equals("*") && type2.equals("*")) {
                return -1;
            }
            if (subType1.equals("*") && !subType2.equals("*")) {
                return 1;
            }
            if (!subType1.equals("*") && subType2.equals("*")) {
                return -1;
            }
            Matcher extmatcher1 = EXT_SUBTYPE_PATTERN.matcher(subType1);
            Matcher extmatcher2 = EXT_SUBTYPE_PATTERN.matcher(subType2);
            if (extmatcher1.matches() && !extmatcher2.matches()) {
                return 1;
            }
            if (!extmatcher1.matches() && extmatcher2.matches()) {
                return -1;
            }
            extmatcher1 = EXT_PREFIX_SUBTYPE_PATTERN.matcher(subType1);
            extmatcher2 = EXT_PREFIX_SUBTYPE_PATTERN.matcher(subType2);
            if (extmatcher1.matches() && !extmatcher2.matches()) {
                return 1;
            }
            if (!extmatcher1.matches() && extmatcher2.matches()) {
                return -1;
            }
            extmatcher1 = EXT_SUFFIX_SUBTYPE_PATTERN.matcher(subType1);
            extmatcher2 = EXT_SUFFIX_SUBTYPE_PATTERN.matcher(subType2);
            if (extmatcher1.matches() && !extmatcher2.matches()) {
                return 1;
            }
            if (!extmatcher1.matches() && extmatcher2.matches()) {
                return -1;
            }
            return 0;
        }
    };

    private MediaTypeHelper() {
    }

    public static List<MediaType> createConsumesList(Consumes mime) {
        if (mime == null) {
            return DEFAULT_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypesList(mime.value());
    }

    public static List<MediaType> createProducesList(Produces mime) {
        if (mime == null) {
            return DEFAULT_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypesList(mime.value());
    }

    public static boolean isConsume(List<MediaType> consumes, MediaType contentType) {
        for (MediaType c : consumes) {
            if (!MediaTypeHelper.isMatched(c, contentType)) continue;
            return true;
        }
        return false;
    }

    private static List<MediaType> createMediaTypesList(String[] mimes) {
        ArrayList<MediaType> l = new ArrayList<MediaType>(mimes.length);
        for (String m : mimes) {
            l.add(MediaType.valueOf((String)m));
        }
        Collections.sort(l, MEDIA_TYPE_COMPARATOR);
        return l;
    }

    public static float processQuality(List<MediaType> accept, List<MediaType> produces) {
        for (AcceptMediaType acceptMediaType : accept) {
            if ("*".equals(acceptMediaType.getType())) {
                return acceptMediaType.getQvalue();
            }
            for (MediaType p : produces) {
                if (!p.isCompatible((MediaType)acceptMediaType)) continue;
                return acceptMediaType.getQvalue();
            }
        }
        return 0.0f;
    }

    public static boolean isCompatible(MediaType one, MediaType two) {
        if (one == null || two == null) {
            throw new IllegalArgumentException("null");
        }
        String oneType = one.getType();
        String twoType = two.getType();
        if (oneType.equals("*") || twoType.equals("*")) {
            return true;
        }
        if (one.getType().equalsIgnoreCase(two.getType())) {
            String oneSubtype = one.getSubtype();
            String twoSubtype = two.getSubtype();
            if (oneSubtype.equals("*") || twoSubtype.equals("*") || oneSubtype.equalsIgnoreCase(twoSubtype)) {
                return true;
            }
            Matcher oneMatcher = EXT_SUBTYPE_PATTERN.matcher(oneSubtype);
            Matcher twoMatcher = EXT_SUBTYPE_PATTERN.matcher(twoSubtype);
            if (!oneMatcher.matches() && twoMatcher.matches()) {
                return oneSubtype.equalsIgnoreCase(twoMatcher.group(1)) || oneSubtype.equalsIgnoreCase(twoMatcher.group(2));
            }
            if (oneMatcher.matches() && !twoMatcher.matches()) {
                return twoSubtype.equalsIgnoreCase(oneMatcher.group(1)) || twoSubtype.equalsIgnoreCase(oneMatcher.group(2));
            }
            if (oneMatcher.matches() && twoMatcher.matches()) {
                String onePrefix = oneMatcher.group(1);
                String oneSuffix = oneMatcher.group(2);
                String twoPrefix = twoMatcher.group(1);
                String twoSuffix = twoMatcher.group(2);
                if (onePrefix.equalsIgnoreCase(twoPrefix) && (oneSuffix.equals("*") || twoSuffix.equals("*"))) {
                    return true;
                }
                if (oneSuffix.equalsIgnoreCase(twoSuffix) && (onePrefix.equals("*") || twoPrefix.equals("*"))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMatched(MediaType pattern, MediaType checkMe) {
        if (pattern == null || checkMe == null) {
            throw new IllegalArgumentException("null");
        }
        if (pattern.getType().equals("*")) {
            return true;
        }
        if (pattern.getType().equalsIgnoreCase(checkMe.getType())) {
            String patternSubtype = pattern.getSubtype();
            String checkMeSubtype = checkMe.getSubtype();
            if (patternSubtype.equals("*") || patternSubtype.equalsIgnoreCase(checkMeSubtype)) {
                return true;
            }
            Matcher patternMatcher = EXT_SUBTYPE_PATTERN.matcher(patternSubtype);
            Matcher checkMeMatcher = EXT_SUBTYPE_PATTERN.matcher(checkMeSubtype);
            if (patternMatcher.matches()) {
                String patternPrefix = patternMatcher.group(1);
                String patternSuffix = patternMatcher.group(2);
                if (!checkMeMatcher.matches()) {
                    return checkMeSubtype.equalsIgnoreCase(patternPrefix) || checkMeSubtype.equalsIgnoreCase(patternSuffix);
                }
                String checkMePrefix = checkMeMatcher.group(1);
                String checkMeSuffix = checkMeMatcher.group(2);
                if (patternPrefix.equalsIgnoreCase(checkMePrefix) && patternSuffix.equals("*")) {
                    return true;
                }
                if (patternSuffix.equalsIgnoreCase(checkMeSuffix) && patternPrefix.equals("*")) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final class MediaTypeRange
    implements Iterator<MediaType> {
        private MediaType next;

        public MediaTypeRange(MediaType type) {
            this.next = type == null ? DEFAULT_TYPE : type;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MediaType next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MediaType type = this.next;
            this.fetchNext();
            return type;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void fetchNext() {
            MediaType mediaType = this.next;
            this.next = null;
            if (!mediaType.isWildcardType() && !mediaType.isWildcardSubtype()) {
                String type = mediaType.getType();
                String subType = mediaType.getSubtype();
                Matcher extMatcher = EXT_SUBTYPE_PATTERN.matcher(subType);
                if (extMatcher.matches()) {
                    String extSubtypePrefix = extMatcher.group(1);
                    String extSubtype = extMatcher.group(2);
                    this.next = "*".equals(extSubtypePrefix) ? new MediaType(type, "*") : new MediaType(type, MediaTypeHelper.EXT_PREFIX_SUBTYPE + extSubtype);
                } else {
                    this.next = new MediaType(type, MediaTypeHelper.EXT_PREFIX_SUBTYPE + subType);
                }
            } else if (!mediaType.isWildcardType() && mediaType.isWildcardSubtype()) {
                this.next = DEFAULT_TYPE;
            }
        }
    }
}

