/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.servlet.EverrestApplication;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.servlet.ServletContextDependencySupplier;

public class EverrestInitializedListener
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent sce) {
        this.makeFileCollectorDestroyer().stopFileCollector();
        ServletContext sctx = sce.getServletContext();
        EverrestProcessor processor = (EverrestProcessor)sctx.getAttribute(EverrestProcessor.class.getName());
        if (processor != null) {
            processor.stop();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer();
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sctx = sce.getServletContext();
        DependencySupplier dependencySupplier = (DependencySupplier)sctx.getAttribute(DependencySupplier.class.getName());
        if (dependencySupplier == null) {
            dependencySupplier = new ServletContextDependencySupplier(sctx);
        }
        ResourceBinderImpl resources = new ResourceBinderImpl();
        ApplicationProviderBinder providers = new ApplicationProviderBinder();
        EverrestServletContextInitializer initializer = new EverrestServletContextInitializer(sctx);
        EverrestConfiguration config = initializer.getConfiguration();
        Application application = initializer.getApplication();
        EverrestApplication everrest = new EverrestApplication(config);
        everrest.addApplication(application);
        EverrestProcessor processor = new EverrestProcessor(resources, providers, dependencySupplier, config, everrest);
        processor.start();
        sctx.setAttribute(EverrestConfiguration.class.getName(), (Object)config);
        sctx.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        sctx.setAttribute(ResourceBinder.class.getName(), (Object)resources);
        sctx.setAttribute(ApplicationProviderBinder.class.getName(), (Object)providers);
        sctx.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
    }
}

