/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.uri;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everrest.core.impl.uri.UriComponent;

public class UriTemplateParser {
    public static final Pattern URI_PARAMETERS_PATTERN = Pattern.compile("\\{[^\\}^\\{]+\\}");
    private static final String REGEX_CHARACTERS = ".?()";
    private static final String URI_PARAMETER_TEMPLATE = "[^/]+?";
    private List<String> names = new ArrayList<String>();
    private StringBuilder regex = new StringBuilder();
    private StringBuilder normalizedTemplate = new StringBuilder();
    private int numberOfCharacters = 0;
    private String name;
    private List<Integer> groupIndexes = new ArrayList<Integer>();

    public UriTemplateParser(String template) {
        Matcher m = URI_PARAMETERS_PATTERN.matcher(template);
        int start = 0;
        while (m.find()) {
            this.numberOfCharacters += this.addCharacter(template, start, m.start());
            this.parseRegex(template.substring(m.start() + 1, m.end() - 1));
            start = m.end();
        }
        this.numberOfCharacters += this.addCharacter(template, start, template.length());
    }

    public final int getNumberOfLiteralCharacters() {
        return this.numberOfCharacters;
    }

    public final List<String> getParameterNames() {
        return this.names;
    }

    public final String getRegex() {
        return this.regex.toString();
    }

    public final String getTemplate() {
        return this.normalizedTemplate.toString();
    }

    public final int[] getGroupIndexes() {
        int i;
        if (this.names.isEmpty()) {
            return null;
        }
        int[] indxs = new int[this.names.size() + 1];
        indxs[0] = 1;
        for (i = 1; i < indxs.length; ++i) {
            indxs[i] = indxs[i - 1] + this.groupIndexes.get(i - 1);
        }
        for (i = 0; i < indxs.length; ++i) {
            if (indxs[i] == i + 1) continue;
            return indxs;
        }
        return null;
    }

    protected String encodeLiteralCharacters(String literalCharacters) {
        return UriComponent.recognizeEncode(literalCharacters, 5, false);
    }

    private void parseRegex(String str) {
        int length = str.length();
        int p = this.parseName(str, 0, length);
        String reg = "";
        if (p == length) {
            reg = URI_PARAMETER_TEMPLATE;
            this.addToTemplate(this.name);
        } else {
            reg = str.substring(p + 1).trim();
            if (reg.length() == 0) {
                reg = URI_PARAMETER_TEMPLATE;
                this.addToTemplate(this.name);
            } else {
                this.addToTemplate(this.name, reg);
            }
        }
        Pattern gp = Pattern.compile(reg);
        Matcher m = gp.matcher("");
        this.groupIndexes.add(m.groupCount() + 1);
        this.regex.append('(').append(reg).append(')');
    }

    private void addToTemplate(String name) {
        this.normalizedTemplate.append('{').append(name).append('}');
    }

    private void addToTemplate(String name, String reg) {
        this.normalizedTemplate.append('{').append(name).append('}').append(':').append(reg);
    }

    private int parseName(String str, int p, int length) {
        StringBuilder sb = new StringBuilder();
        while (p < length) {
            char ch = str.charAt(p);
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_' || ch == '.') {
                sb.append(ch);
            } else {
                if (ch == ':') break;
                if (ch != ' ') {
                    throw new IllegalArgumentException("Wrong character at part " + str);
                }
            }
            ++p;
        }
        this.name = sb.toString();
        if (this.names.contains(this.name)) {
            throw new IllegalArgumentException("URI template variables name " + this.name + " already registered.");
        }
        this.names.add(this.name);
        return p;
    }

    private int addCharacter(String template, int start, int end) {
        String str = this.encodeLiteralCharacters(template.substring(start, end));
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (REGEX_CHARACTERS.indexOf(ch) != -1) {
                this.regex.append('\\');
            }
            this.regex.append(ch);
            this.normalizedTemplate.append(ch);
        }
        return end - start;
    }
}

