/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.security.Principal;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobRejectedException;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.method.DefaultMethodInvoker;
import org.everrest.core.resource.GenericMethodResource;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.tools.DummySecurityContext;
import org.everrest.core.tools.EmptyInputStream;
import org.everrest.core.tools.SecurityContextRequest;
import org.everrest.core.tools.SimplePrincipal;

public class AsynchronousMethodInvoker
extends DefaultMethodInvoker {
    private final AsynchronousJobPool pool;

    public AsynchronousMethodInvoker(AsynchronousJobPool pool) {
        this.pool = pool;
    }

    @Override
    public Object invokeMethod(Object resource, GenericMethodResource methodResource, Object[] params, ApplicationContext context) {
        try {
            GenericContainerRequest request = context.getContainerRequest();
            Principal principal = request.getUserPrincipal();
            SimplePrincipal copyPrincipal = null;
            if (principal != null) {
                copyPrincipal = new SimplePrincipal(principal.getName());
            }
            SecurityContextRequest copyRequest = new SecurityContextRequest(request.getMethod(), request.getRequestUri(), request.getBaseUri(), new EmptyInputStream(), (MultivaluedMap<String, String>)request.getRequestHeaders(), new DummySecurityContext(copyPrincipal));
            AsynchronousJob job = this.pool.addJob(resource, (ResourceMethodDescriptor)methodResource, params);
            job.getContext().put("org.everrest.async.request", copyRequest);
            job.getContext().put("org.everrest.async.providers", context.getProviders());
            String jobUri = context.getBaseUriBuilder().path(AsynchronousJobService.class, "get").build(new Object[]{job.getJobId()}).toString();
            return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)jobUri).entity((Object)jobUri).type("text/plain").build();
        }
        catch (AsynchronousJobRejectedException e) {
            return Response.serverError().entity((Object)e.getMessage()).type("text/plain").build();
        }
    }
}

