/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.impl.ContainerRequest;

public class SecurityContextRequest
extends ContainerRequest {
    private final SecurityContext securityContext;

    public SecurityContextRequest(String method, URI requestUri, URI baseUri, InputStream entityStream, MultivaluedMap<String, String> httpHeaders, SecurityContext securityContext) {
        super(method, requestUri, baseUri, entityStream, httpHeaders);
        this.securityContext = securityContext;
    }

    @Override
    public String getAuthenticationScheme() {
        return this.securityContext != null ? this.securityContext.getAuthenticationScheme() : null;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.securityContext != null ? this.securityContext.getUserPrincipal() : null;
    }

    @Override
    public boolean isSecure() {
        return this.securityContext != null && this.securityContext.isSecure();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.securityContext != null && this.securityContext.isUserInRole(role);
    }
}

