/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.DependencySupplier;
import org.everrest.core.FieldInjector;
import org.everrest.core.impl.method.ParameterHelper;
import org.everrest.core.impl.method.ParameterResolverFactory;
import org.everrest.core.resource.ResourceDescriptorVisitor;

public class FieldInjectorImpl
implements FieldInjector {
    private final Annotation[] annotations;
    private final Annotation annotation;
    private final String defaultValue;
    private final boolean encoded;
    private final Field jField;
    private final Method setter;

    public FieldInjectorImpl(Class<?> resourceClass, Field jField) {
        this.jField = jField;
        this.annotations = jField.getDeclaredAnnotations();
        this.setter = FieldInjectorImpl.getSetter(resourceClass, jField);
        Annotation annotation = null;
        String defaultValue = null;
        boolean encoded = false;
        boolean provider = resourceClass.getAnnotation(Provider.class) != null;
        List<String> allowedAnnotation = provider ? ParameterHelper.PROVIDER_FIELDS_ANNOTATIONS : ParameterHelper.RESOURCE_FIELDS_ANNOTATIONS;
        for (Annotation a : this.annotations) {
            Class<? extends Annotation> ac = a.annotationType();
            if (allowedAnnotation.contains(ac.getName())) {
                if (annotation != null) {
                    throw new RuntimeException("JAX-RS annotations on one of fields " + jField.toString() + " are equivocality. Annotations: " + ((Object)annotation).toString() + " and " + ((Object)a).toString() + " can't be applied to one field. ");
                }
                annotation = a;
                continue;
            }
            if (ac == Encoded.class && !provider) {
                encoded = true;
                continue;
            }
            if (ac != DefaultValue.class || provider) continue;
            defaultValue = ((DefaultValue)a).value();
        }
        this.defaultValue = defaultValue;
        this.annotation = annotation;
        this.encoded = encoded || resourceClass.getAnnotation(Encoded.class) != null;
    }

    private static Method getSetter(Class<?> clazz, Field jfield) {
        Method setter = null;
        try {
            String name = jfield.getName();
            String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            setter = clazz.getMethod(setterName, jfield.getType());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return setter;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getParameterClass() {
        return this.jField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.jField.getGenericType();
    }

    @Override
    public boolean isEncoded() {
        return this.encoded;
    }

    @Override
    public String getName() {
        return this.jField.getName();
    }

    @Override
    public void inject(Object resource, ApplicationContext context) {
        try {
            Object value = null;
            if (this.annotation != null) {
                value = ParameterResolverFactory.createParameterResolver(this.annotation).resolve(this, context);
            } else {
                DependencySupplier dependencies = context.getDependencySupplier();
                if (dependencies != null) {
                    value = dependencies.getComponent(this);
                }
            }
            if (value != null) {
                if (this.setter != null) {
                    this.setter.invoke(resource, value);
                } else {
                    if (!Modifier.isPublic(this.jField.getModifiers())) {
                        this.jField.setAccessible(true);
                    }
                    this.jField.set(resource, value);
                }
            }
        }
        catch (Exception e) {
            if (this.annotation != null) {
                Class<? extends Annotation> ac = this.annotation.annotationType();
                if (ac == PathParam.class || ac == QueryParam.class || ac == MatrixParam.class) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
            }
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFieldInjector(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ FieldInjectorImpl: ");
        sb.append("annotation: ");
        sb.append(this.getAnnotation());
        sb.append("; type: ");
        sb.append(this.getParameterClass());
        sb.append("; generic-type : ");
        sb.append(this.getGenericType());
        sb.append("; default-value: ");
        sb.append(this.getDefaultValue());
        sb.append("; encoded: ");
        sb.append(this.isEncoded());
        sb.append(" ]");
        return sb.toString();
    }
}

