/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.everrest.core.BaseObjectModel;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.impl.method.MethodParameterImpl;
import org.everrest.core.impl.method.ParameterHelper;
import org.everrest.core.impl.resource.OptionsRequestResourceMethodDescriptorImpl;
import org.everrest.core.impl.resource.PathValue;
import org.everrest.core.impl.resource.ResourceMethodDescriptorImpl;
import org.everrest.core.impl.resource.SubResourceLocatorDescriptorImpl;
import org.everrest.core.impl.resource.SubResourceMethodDescriptorImpl;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.resource.ResourceMethodMap;
import org.everrest.core.resource.SubResourceLocatorMap;
import org.everrest.core.resource.SubResourceMethodDescriptor;
import org.everrest.core.resource.SubResourceMethodMap;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Logger;

public class AbstractResourceDescriptorImpl
extends BaseObjectModel
implements AbstractResourceDescriptor {
    private static final Logger LOG = Logger.getLogger(AbstractResourceDescriptorImpl.class);
    private final PathValue path;
    private final UriPattern uriPattern;
    private final SubResourceMethodMap subResourceMethods;
    private final SubResourceLocatorMap subResourceLocators;
    private final ResourceMethodMap<ResourceMethodDescriptor> resourceMethods;

    public AbstractResourceDescriptorImpl(Class<?> resourceClass, ComponentLifecycleScope scope) {
        this(resourceClass.getAnnotation(Path.class), resourceClass, scope);
    }

    private AbstractResourceDescriptorImpl(Path path, Class<?> resourceClass, ComponentLifecycleScope scope) {
        super(resourceClass, scope);
        if (path == null) {
            this.path = null;
            this.uriPattern = null;
        } else {
            this.path = new PathValue(path.value());
            this.uriPattern = new UriPattern(path.value());
        }
        this.resourceMethods = new ResourceMethodMap();
        this.subResourceMethods = new SubResourceMethodMap();
        this.subResourceLocators = new SubResourceLocatorMap();
        this.processMethods();
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitAbstractResourceDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public ResourceMethodMap<ResourceMethodDescriptor> getResourceMethods() {
        return this.resourceMethods;
    }

    @Override
    public SubResourceLocatorMap getSubResourceLocators() {
        return this.subResourceLocators;
    }

    @Override
    public SubResourceMethodMap getSubResourceMethods() {
        return this.subResourceMethods;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public boolean isRootResource() {
        return this.path != null;
    }

    protected void processMethods() {
        Class<?> resourceClass = this.getObjectClass();
        for (Method method : resourceClass.getDeclaredMethods()) {
            for (Annotation a : method.getAnnotations()) {
                Class<? extends Annotation> aClass = a.annotationType();
                if (Modifier.isPublic(method.getModifiers()) || aClass != CookieParam.class && aClass != Consumes.class && aClass != Context.class && aClass != DefaultValue.class && aClass != Encoded.class && aClass != FormParam.class && aClass != HeaderParam.class && aClass != MatrixParam.class && aClass != Path.class && aClass != PathParam.class && aClass != Produces.class && aClass != QueryParam.class && aClass.getAnnotation(HttpMethod.class) == null) continue;
                LOG.warn("Non-public method at resource " + this.toString() + " annotated with JAX-RS annotation: " + a);
            }
        }
        for (Method method : resourceClass.getMethods()) {
            Annotation[] additional;
            Annotation[] annotationArray;
            Path subPath = this.getMethodAnnotation(method, resourceClass, Path.class, false);
            HttpMethod httpMethod = this.getMethodAnnotation(method, resourceClass, HttpMethod.class, true);
            if (subPath == null && httpMethod == null) continue;
            List<MethodParameter> params = this.createMethodParametersList(resourceClass, method);
            Object security = this.getSecurityAnnotation(method, resourceClass);
            if (security != null) {
                Annotation[] annotationArray2 = new Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = security;
            } else {
                annotationArray = additional = new Annotation[]{};
            }
            if (httpMethod != null) {
                Produces p = this.getMethodAnnotation(method, resourceClass, Produces.class, false);
                if (p == null) {
                    p = resourceClass.getAnnotation(Produces.class);
                }
                List<MediaType> produces = MediaTypeHelper.createProducesList(p);
                Consumes c = this.getMethodAnnotation(method, resourceClass, Consumes.class, false);
                if (c == null) {
                    c = resourceClass.getAnnotation(Consumes.class);
                }
                List<MediaType> consumes = MediaTypeHelper.createConsumesList(c);
                if (subPath == null) {
                    ResourceMethodDescriptorImpl res = new ResourceMethodDescriptorImpl(method, httpMethod.value(), params, this, consumes, produces, additional);
                    ResourceMethodDescriptor exist = this.findMethodResourceMediaType(this.resourceMethods.getList(httpMethod.value()), res.consumes(), res.produces());
                    if (exist == null) {
                        this.resourceMethods.add(httpMethod.value(), res);
                        continue;
                    }
                    throw new RuntimeException("Two resource method " + res + " and " + exist + " with the same HTTP method, consumes and produces found. ");
                }
                SubResourceMethodDescriptorImpl subRes = new SubResourceMethodDescriptorImpl(new PathValue(subPath.value()), method, httpMethod.value(), params, this, consumes, produces, additional);
                ResourceMethodMap<SubResourceMethodDescriptor> map = this.subResourceMethods.getMethodMap(subRes.getUriPattern());
                SubResourceMethodDescriptor exist = (SubResourceMethodDescriptor)this.findMethodResourceMediaType(map.getList(httpMethod.value()), subRes.consumes(), subRes.produces());
                if (exist == null) {
                    map.add(httpMethod.value(), subRes);
                    continue;
                }
                throw new RuntimeException("Two sub-resource method " + subRes + " and " + exist + " with the same HTTP method, path, consumes and produces found. ");
            }
            if (subPath == null) continue;
            SubResourceLocatorDescriptorImpl locator = new SubResourceLocatorDescriptorImpl(new PathValue(subPath.value()), method, params, this, additional);
            if (!this.subResourceLocators.containsKey(locator.getUriPattern())) {
                this.subResourceLocators.put(locator.getUriPattern(), locator);
                continue;
            }
            throw new RuntimeException("Two sub-resource locators " + locator + " and " + this.subResourceLocators.get(locator.getUriPattern()) + " with the same path found. ");
        }
        if (this.resourceMethods.size() + this.subResourceMethods.size() + this.subResourceLocators.size() == 0) {
            String msg = "Not found any resource methods, sub-resource methods or sub-resource locators in " + resourceClass.getName();
            LOG.warn(msg);
        }
        this.resolveHeadRequest();
        this.resolveOptionsRequest();
        this.resourceMethods.sort();
        this.subResourceMethods.sort();
    }

    protected List<MethodParameter> createMethodParametersList(Class<?> resourceClass, Method method) {
        Class<?>[] parameterClasses = method.getParameterTypes();
        if (parameterClasses.length > 0) {
            Type[] parameterGenTypes = method.getGenericParameterTypes();
            Annotation[][] annotations = method.getParameterAnnotations();
            ArrayList<MethodParameter> params = new ArrayList<MethodParameter>(parameterClasses.length);
            boolean classEncoded = resourceClass.getAnnotation(Encoded.class) != null;
            boolean methodEncoded = method.getAnnotation(Encoded.class) != null;
            for (int i = 0; i < parameterClasses.length; ++i) {
                String defaultValue = null;
                Annotation annotation = null;
                boolean encoded = false;
                for (int j = 0; j < annotations[i].length; ++j) {
                    Annotation a = annotations[i][j];
                    Class<? extends Annotation> aClass = a.annotationType();
                    if (ParameterHelper.RESOURCE_METHOD_PARAMETER_ANNOTATIONS.contains(aClass.getName())) {
                        if (annotation != null) {
                            String msg = "JAX-RS annotations on one of method parameters of resource " + this.toString() + ", method " + method.getName() + " are equivocality. " + "Annotations: " + annotation + " and " + a + " can't be applied to one parameter. ";
                            throw new RuntimeException(msg);
                        }
                        annotation = a;
                        continue;
                    }
                    if (aClass == Encoded.class) {
                        encoded = true;
                        continue;
                    }
                    if (aClass == DefaultValue.class) {
                        defaultValue = ((DefaultValue)a).value();
                        continue;
                    }
                    LOG.warn("Method parameter of resource " + this.toString() + ", method " + method.getName() + " contains unknown or not valid JAX-RS annotation " + ((Object)a).toString() + ". It will be ignored.");
                }
                MethodParameterImpl mp = new MethodParameterImpl(annotation, annotations[i], parameterClasses[i], parameterGenTypes[i], defaultValue, encoded || methodEncoded || classEncoded);
                params.add(mp);
            }
            return params;
        }
        return Collections.emptyList();
    }

    protected void resolveHeadRequest() {
        List getResources = (List)this.resourceMethods.get("GET");
        if (getResources != null && getResources.size() > 0) {
            List<ResourceMethodDescriptor> headResources = this.resourceMethods.getList("HEAD");
            for (ResourceMethodDescriptor resourceMethod : getResources) {
                if (this.findMethodResourceMediaType(headResources, resourceMethod.consumes(), resourceMethod.produces()) != null) continue;
                headResources.add(new ResourceMethodDescriptorImpl(resourceMethod.getMethod(), "HEAD", resourceMethod.getMethodParameters(), this, resourceMethod.consumes(), resourceMethod.produces(), resourceMethod.getAnnotations()));
            }
        }
        for (ResourceMethodMap map : this.subResourceMethods.values()) {
            List getSubResources = (List)map.get("GET");
            if (getSubResources == null || getSubResources.size() <= 0) continue;
            List headSubResources = map.getList("HEAD");
            for (SubResourceMethodDescriptor subResourceMethod : getSubResources) {
                if (this.findMethodResourceMediaType(headSubResources, subResourceMethod.consumes(), subResourceMethod.produces()) != null) continue;
                headSubResources.add(new SubResourceMethodDescriptorImpl(subResourceMethod.getPathValue(), subResourceMethod.getMethod(), "HEAD", subResourceMethod.getMethodParameters(), this, subResourceMethod.consumes(), subResourceMethod.produces(), subResourceMethod.getAnnotations()));
            }
        }
    }

    protected void resolveOptionsRequest() {
        List<ResourceMethodDescriptor> optionResources = this.resourceMethods.getList("OPTIONS");
        if (optionResources.size() == 0) {
            List<MethodParameter> mps = Collections.emptyList();
            List<MediaType> consumes = MediaTypeHelper.DEFAULT_TYPE_LIST;
            List<MediaType> produces = Collections.singletonList(MediaTypeHelper.WADL_TYPE);
            optionResources.add(new OptionsRequestResourceMethodDescriptorImpl(null, "OPTIONS", mps, this, consumes, produces, new Annotation[0]));
        }
    }

    protected <T extends Annotation> T getMetaAnnotation(Method m, Class<T> annotation) {
        for (Annotation a : m.getAnnotations()) {
            T endPoint = a.annotationType().getAnnotation(annotation);
            if (endPoint == null) continue;
            return endPoint;
        }
        return null;
    }

    protected <T extends Annotation> T getMethodAnnotation(Method method, Class<?> resourceClass, Class<T> annotationClass, boolean metaAnnotation) {
        T annotation;
        T t = annotation = metaAnnotation ? this.getMetaAnnotation(method, annotationClass) : method.getAnnotation(annotationClass);
        if (annotation == null) {
            Method inhMethod = null;
            try {
                Class<?> superclass = resourceClass.getSuperclass();
                if (superclass != null && superclass != Object.class) {
                    inhMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            if (inhMethod == null) {
                for (Class<?> interf : resourceClass.getInterfaces()) {
                    try {
                        Method tmp = interf.getMethod(method.getName(), method.getParameterTypes());
                        if (inhMethod != null) {
                            throw new RuntimeException("JAX-RS annotation on method " + inhMethod.getName() + " of resource " + this.toString() + " is equivocality.");
                        }
                        inhMethod = tmp;
                    }
                    catch (NoSuchMethodException ignored) {
                        // empty catch block
                    }
                }
            }
            if (inhMethod != null) {
                annotation = metaAnnotation ? this.getMetaAnnotation(inhMethod, annotationClass) : inhMethod.getAnnotation(annotationClass);
            }
        }
        return annotation;
    }

    protected <T extends ResourceMethodDescriptor> ResourceMethodDescriptor findMethodResourceMediaType(List<T> resourceMethods, List<MediaType> consumes, List<MediaType> produces) {
        ResourceMethodDescriptor matched = null;
        Iterator<T> iterator = resourceMethods.iterator();
        while (matched == null && iterator.hasNext()) {
            ResourceMethodDescriptor method = (ResourceMethodDescriptor)iterator.next();
            if (method.consumes().size() != consumes.size() || method.produces().size() != produces.size() || !method.consumes().containsAll(consumes) || !method.produces().containsAll(produces)) continue;
            matched = method;
        }
        return matched;
    }

    private <T extends Annotation> T getSecurityAnnotation(Method method, Class<?> clazz) {
        Class[] aClasses = new Class[]{DenyAll.class, RolesAllowed.class, PermitAll.class};
        T a = this.getAnnotation(method, aClasses);
        if (a == null && (a = this.getAnnotation(clazz, aClasses)) == null) {
            Method inheritedMethod;
            Class<?> superclass = clazz.getSuperclass();
            try {
                if (superclass != null && superclass != Object.class) {
                    inheritedMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                    a = this.getAnnotation(inheritedMethod, aClasses);
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            if (a == null) {
                if (superclass != null && superclass != Object.class) {
                    a = this.getAnnotation(superclass, aClasses);
                }
                if (a == null) {
                    Class<?>[] interfaces = clazz.getInterfaces();
                    for (int k = 0; a == null && k < interfaces.length; ++k) {
                        try {
                            inheritedMethod = interfaces[k].getMethod(method.getName(), method.getParameterTypes());
                            a = this.getAnnotation(inheritedMethod, aClasses);
                        }
                        catch (NoSuchMethodException ignored) {
                            // empty catch block
                        }
                        if (a != null) continue;
                        a = this.getAnnotation(interfaces[k], aClasses);
                    }
                }
            }
        }
        return a;
    }

    private <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T>[] aClasses) {
        T a = null;
        for (int i = 0; a == null && i < aClasses.length; ++i) {
            a = clazz.getAnnotation(aClasses[i]);
        }
        return a;
    }

    private <T extends Annotation> T getAnnotation(Method method, Class<T>[] aClasses) {
        T a = null;
        for (int i = 0; a == null && i < aClasses.length; ++i) {
            a = method.getAnnotation(aClasses[i]);
        }
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ AbstractResourceDescriptorImpl: ");
        sb.append("path: ");
        sb.append(this.getPathValue());
        sb.append("; isRootResource: ");
        sb.append(this.isRootResource());
        sb.append("; class: ");
        sb.append(this.getObjectClass());
        sb.append(" ]");
        return sb.toString();
    }
}

