/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import org.everrest.core.impl.InternalException;
import org.everrest.core.resource.ResourceMethodDescriptor;

public class AsynchronousJob {
    private final String jobId;
    private final long expirationDate;
    private final ResourceMethodDescriptor method;
    private final Future<Object> future;
    private final Map<String, Object> context;

    protected AsynchronousJob(String jobId, Future<Object> future, long expirationDate, ResourceMethodDescriptor method) {
        this.future = future;
        this.jobId = jobId;
        this.expirationDate = expirationDate;
        this.method = method;
        this.context = new HashMap<String, Object>();
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public ResourceMethodDescriptor getResourceMethod() {
        return this.method;
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean cancel() {
        return this.future.cancel(true);
    }

    public Object getResult() throws IllegalStateException {
        Object result;
        if (!this.isDone()) {
            throw new IllegalStateException("Job is not done yet. ");
        }
        try {
            result = this.future.get();
        }
        catch (InterruptedException e) {
            throw new InternalException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException && (cause = ((InvocationTargetException)cause).getTargetException()) instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new InternalException(cause);
        }
        return result;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

