/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.everrest.core.BaseObjectModel;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.provider.ProviderDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;

public class ProviderDescriptorImpl
extends BaseObjectModel
implements ProviderDescriptor {
    private final List<MediaType> consumes;
    private final List<MediaType> produces;

    public ProviderDescriptorImpl(Class<?> providerClass, ComponentLifecycleScope scope) {
        super(providerClass, scope);
        this.consumes = MediaTypeHelper.createConsumesList(providerClass.getAnnotation(Consumes.class));
        this.produces = MediaTypeHelper.createProducesList(providerClass.getAnnotation(Produces.class));
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitProviderDescriptor(this);
    }

    @Override
    public List<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ProviderDescriptorImpl: ");
        sb.append("provider class: ");
        sb.append(this.getObjectClass());
        sb.append("; produces media type: ");
        sb.append(this.produces());
        sb.append("; consumes media type: ");
        sb.append(this.consumes());
        sb.append("; ");
        sb.append(this.getConstructorDescriptors());
        sb.append("; ");
        sb.append(this.getFieldInjectors());
        sb.append(" ]");
        return sb.toString();
    }
}

