/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;

public class DummySecurityContext
implements SecurityContext {
    private final Principal principal;
    private final Set<String> userRoles;

    public DummySecurityContext(Principal principal, Set<String> userRoles) {
        this.principal = principal;
        this.userRoles = Collections.unmodifiableSet(new HashSet<String>(userRoles));
    }

    public DummySecurityContext(Principal principal) {
        this.principal = principal;
        this.userRoles = Collections.emptySet();
    }

    public String getAuthenticationScheme() {
        return "BASIC";
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public Set<String> getUserRoles() {
        return this.userRoles;
    }
}

