/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;

public final class EverrestProcessor {
    private RequestHandler requestHandler;
    private ResourceBinder resources;
    private ProviderBinder providers;

    public EverrestProcessor(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencies, EverrestConfiguration config, Application application) {
        this.resources = resources;
        this.providers = providers;
        this.requestHandler = new RequestHandlerImpl(new RequestDispatcher(resources), providers, dependencies, config);
        if (application != null) {
            this.addApplication(application);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GenericContainerRequest request, GenericContainerResponse response, EnvironmentContext envCtx) throws UnhandledException, IOException {
        try {
            EnvironmentContext.setCurrent(envCtx);
            this.requestHandler.handleRequest(request, response);
        }
        finally {
            EnvironmentContext.setCurrent(null);
        }
    }

    public void addApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("application");
        }
        new ApplicationPublisher(this.resources, this.providers).publish(application);
    }
}

