/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.util.CaselessStringWrapper;

public class CaselessMultivaluedMap<T>
implements ExtMultivaluedMap<String, T>,
Serializable {
    private static final long serialVersionUID = -4159372000926269780L;
    ExtMultivaluedMapImpl m;
    Set<String> keys;
    Set<Map.Entry<String, List<T>>> entries;

    public CaselessMultivaluedMap() {
        this.m = new ExtMultivaluedMapImpl();
    }

    public CaselessMultivaluedMap(int capasity) {
        this.m = new ExtMultivaluedMapImpl(capasity);
    }

    public CaselessMultivaluedMap(Map<String, List<T>> m) {
        this.m = new ExtMultivaluedMapImpl(m.size());
        for (Map.Entry<String, List<T>> e : m.entrySet()) {
            this.m.put(new CaselessStringWrapper(e.getKey()), e.getValue());
        }
    }

    public void add(String key, T value) {
        this.m.add(new CaselessStringWrapper(key), value);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return this.m.containsKey(new CaselessStringWrapper(null));
        }
        if (!(key instanceof String)) {
            return false;
        }
        return this.m.containsKey(new CaselessStringWrapper((String)key));
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set<Map.Entry<String, List<T>>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    public List<T> get(Object key) {
        if (key == null) {
            return (List)this.m.get(new CaselessStringWrapper(null));
        }
        if (!(key instanceof String)) {
            return null;
        }
        return (List)this.m.get(new CaselessStringWrapper((String)key));
    }

    public T getFirst(String key) {
        return this.m.getFirst(new CaselessStringWrapper(key));
    }

    @Override
    public List<T> getList(String key) {
        CaselessStringWrapper caselessKey = new CaselessStringWrapper(key);
        ArrayList list = (ArrayList)this.m.get(caselessKey);
        if (list == null) {
            list = new ArrayList();
            this.m.put(caselessKey, list);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<String> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public List<T> put(String key, List<T> value) {
        return this.m.put(new CaselessStringWrapper(key), value);
    }

    public void putAll(Map<? extends String, ? extends List<T>> m) {
        for (String string : m.keySet()) {
            List<T> values = m.get(string);
            for (T v : values) {
                this.add(string, v);
            }
        }
    }

    public void putSingle(String key, T value) {
        this.m.putSingle(new CaselessStringWrapper(key), value);
    }

    public List<T> remove(Object key) {
        if (key == null) {
            return (List)this.m.remove(new CaselessStringWrapper(null));
        }
        if (!(key instanceof String)) {
            return null;
        }
        return (List)this.m.remove(new CaselessStringWrapper((String)key));
    }

    public int size() {
        return this.m.size();
    }

    public Collection<List<T>> values() {
        return this.m.values();
    }

    class ExtMultivaluedMapImpl
    extends HashMap<CaselessStringWrapper, List<T>>
    implements ExtMultivaluedMap<CaselessStringWrapper, T> {
        private static final long serialVersionUID = -1357174424906146761L;

        ExtMultivaluedMapImpl() {
        }

        ExtMultivaluedMapImpl(int initialCapacity) {
            super(initialCapacity);
        }

        ExtMultivaluedMapImpl(Map<CaselessStringWrapper, List<T>> m) {
            super(m);
        }

        public void add(CaselessStringWrapper key, T value) {
            if (value == null) {
                return;
            }
            List list = this.getList(key);
            list.add(value);
        }

        public T getFirst(CaselessStringWrapper key) {
            List list = (List)this.get(key);
            return list != null && list.size() > 0 ? (Object)list.get(0) : null;
        }

        @Override
        public List<T> getList(CaselessStringWrapper key) {
            ArrayList list = (ArrayList)this.get(key);
            if (list == null) {
                list = new ArrayList();
                this.put(key, list);
            }
            return list;
        }

        public void putSingle(CaselessStringWrapper key, T value) {
            if (value == null) {
                this.remove(key);
                return;
            }
            List list = this.getList(key);
            list.clear();
            list.add(value);
        }
    }

    class KeySet
    extends AbstractSet<String> {
        KeySet() {
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public void clear() {
            CaselessMultivaluedMap.this.m.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return CaselessMultivaluedMap.this.m.keySet().contains(new CaselessStringWrapper(null));
            }
            if (!(o instanceof String)) {
                return false;
            }
            return CaselessMultivaluedMap.this.m.keySet().contains(new CaselessStringWrapper((String)o));
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<CaselessStringWrapper> i;
                {
                    this.i = CaselessMultivaluedMap.this.m.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().getString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return CaselessMultivaluedMap.this.m.keySet().remove(new CaselessStringWrapper(null));
            }
            if (!(o instanceof String)) {
                return false;
            }
            return CaselessMultivaluedMap.this.m.keySet().remove(new CaselessStringWrapper((String)o));
        }

        @Override
        public int size() {
            return CaselessMultivaluedMap.this.m.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<String, List<T>>> {
        EntrySet() {
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, List<T>>> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public void clear() {
            CaselessMultivaluedMap.this.m.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if ((k == null || k instanceof String) && (v == null || v instanceof List)) {
                return CaselessMultivaluedMap.this.m.entrySet().contains(new CaselessEntry(new CaselessStringWrapper((String)k), (List)v));
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<String, List<T>>> iterator() {
            return new Iterator<Map.Entry<String, List<T>>>(){
                private Iterator<Map.Entry<CaselessStringWrapper, List<T>>> i;
                {
                    this.i = CaselessMultivaluedMap.this.m.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, List<T>> next() {
                    return new EntryAdapter(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if ((k == null || k instanceof String) && (v == null || v instanceof List)) {
                return CaselessMultivaluedMap.this.m.entrySet().remove(new CaselessEntry(new CaselessStringWrapper((String)k), (List)v));
            }
            return false;
        }

        @Override
        public int size() {
            return CaselessMultivaluedMap.this.m.size();
        }
    }

    class EntryAdapter
    implements Map.Entry<String, List<T>> {
        private Map.Entry<CaselessStringWrapper, List<T>> entry;

        public EntryAdapter(Map.Entry<CaselessStringWrapper, List<T>> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().getString();
        }

        @Override
        public List<T> getValue() {
            return this.entry.getValue();
        }

        @Override
        public List<T> setValue(List<T> value) {
            return this.entry.setValue(value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    class CaselessEntry
    implements Map.Entry<CaselessStringWrapper, List<T>> {
        private CaselessStringWrapper key;
        private List<T> value;

        public CaselessEntry(CaselessStringWrapper key, List<T> value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public CaselessStringWrapper getKey() {
            return this.key;
        }

        @Override
        public List<T> getValue() {
            return this.value;
        }

        @Override
        public List<T> setValue(List<T> value) {
            List old = this.value;
            this.value = value;
            return old;
        }
    }
}

