/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.JsonWriter;

public class ObjectValue
extends JsonValue {
    private final Map<String, JsonValue> children = new LinkedHashMap<String, JsonValue>();

    @Override
    public void addElement(String key, JsonValue child) {
        this.children.put(key, child);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Iterator<String> getKeys() {
        return this.children.keySet().iterator();
    }

    @Override
    public JsonValue getElement(String key) {
        return this.children.get(key);
    }

    @Override
    public String toString() {
        StringWriter w = new StringWriter();
        JsonWriter jw = new JsonWriter(w);
        try {
            this.writeTo(jw);
        }
        catch (JsonException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return w.toString();
    }

    @Override
    public void writeTo(JsonWriter writer) throws JsonException {
        writer.writeStartObject();
        for (String key : this.children.keySet()) {
            writer.writeKey(key);
            JsonValue v = this.children.get(key);
            v.writeTo(writer);
        }
        writer.writeEndObject();
    }
}

