/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.util.ArrayList;
import org.everrest.core.header.AbstractHeaderDelegate;
import org.everrest.core.impl.header.Ranges;

public class RangeHeaderDelegate
extends AbstractHeaderDelegate<Ranges> {
    @Override
    public Class<Ranges> support() {
        return Ranges.class;
    }

    public Ranges fromString(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
        if (!value.startsWith("bytes")) {
            throw new IllegalArgumentException("Invalid byte range.");
        }
        value = value.substring(value.indexOf("=") + 1);
        String[] tokens = value.split(",");
        ArrayList<Ranges.Range> r = new ArrayList<Ranges.Range>();
        for (String token : tokens) {
            long start = 0L;
            long end = -1L;
            int dash = (token = token.trim()).indexOf("-");
            if (dash == -1) {
                throw new IllegalArgumentException("Invalid byte range.");
            }
            if (dash == 0) {
                start = Long.parseLong(token);
            } else if (dash > 0) {
                start = Long.parseLong(token.substring(0, dash).trim());
                if (dash < token.length() - 1) {
                    end = Long.parseLong(token.substring(dash + 1, token.length()).trim());
                }
            }
            r.add(new Ranges.Range(start, end));
        }
        return new Ranges(r);
    }

    public String toString(Ranges value) {
        throw new UnsupportedOperationException();
    }
}

