/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.ext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;

class InMemoryFileItem
implements FileItem {
    private _ByteArrayOutputStream bout;
    private String contentType;
    private String fieldName;
    private boolean isFormField;
    private final String fileName;
    private final int maxSize;
    private static final byte[] EMPTY_DATA = new byte[0];

    InMemoryFileItem(String contentType, String fieldName, boolean isFormField, String fileName, int maxSize) {
        this.contentType = contentType;
        this.fieldName = fieldName;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.maxSize = maxSize;
    }

    public void delete() {
        if (this.bout != null) {
            this.bout.delete();
        }
    }

    public byte[] get() {
        if (this.bout == null) {
            return EMPTY_DATA;
        }
        return this.bout.getByteArray();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.get());
    }

    public String getName() {
        return this.fileName;
    }

    public OutputStream getOutputStream() {
        if (this.bout == null) {
            this.bout = new _ByteArrayOutputStream(this.maxSize);
        }
        return this.bout;
    }

    public long getSize() {
        return this.get().length;
    }

    public String getString() {
        return new String(this.get());
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public boolean isInMemory() {
        return true;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public void write(File file) throws Exception {
        throw new UnsupportedOperationException();
    }

    class _ByteArrayOutputStream
    extends ByteArrayOutputStream {
        public _ByteArrayOutputStream(int size) {
            super(size);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (len == 0) {
                return;
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            int newCount = this.count + len;
            if (newCount > this.buf.length) {
                throw new WebApplicationException(Response.status((int)413).entity((Object)("Item size is to large. Must not be over " + this.buf.length)).type("text/plain").build());
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count = newCount;
        }

        @Override
        public void write(int b) {
            int newCount = this.count + 1;
            if (newCount > this.buf.length) {
                throw new WebApplicationException(Response.status((int)413).entity((Object)("Item size is to large. Must not be over " + this.buf.length)).type("text/plain").build());
            }
            this.buf[this.count] = (byte)b;
            this.count = newCount;
        }

        void delete() {
            this.buf = null;
        }

        byte[] getByteArray() {
            byte[] copy = new byte[this.count];
            System.arraycopy(this.buf, 0, copy, 0, this.count);
            return copy;
        }

        int getCount() {
            return this.count;
        }
    }
}

