/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.everrest.core.impl.resource.PathValue;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.resource.SubResourceMethodDescriptor;
import org.everrest.core.uri.UriPattern;

public class SubResourceMethodDescriptorImpl
implements SubResourceMethodDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;
    private final Method method;
    private final String httpMethod;
    private final List<MethodParameter> parameters;
    private final AbstractResourceDescriptor parentResource;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final Annotation[] additional;

    SubResourceMethodDescriptorImpl(PathValue path, Method method, String httpMethod, List<MethodParameter> parameters, AbstractResourceDescriptor parentResource, List<MediaType> consumes, List<MediaType> produces, Annotation[] additional) {
        this.path = path;
        this.uriPattern = new UriPattern(path.getPath());
        this.method = method;
        this.httpMethod = httpMethod;
        this.parameters = parameters;
        this.parentResource = parentResource;
        this.consumes = consumes;
        this.produces = produces;
        this.additional = additional;
    }

    @Override
    public List<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitSubResourceMethodDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public List<MethodParameter> getMethodParameters() {
        return this.parameters;
    }

    @Override
    public AbstractResourceDescriptor getParentResource() {
        return this.parentResource;
    }

    @Override
    public Class<?> getResponseType() {
        return this.getMethod().getReturnType();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.additional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ SubResourceMethodDescriptorImpl: ");
        sb.append("resource: ");
        sb.append(this.getParentResource());
        sb.append("; path: ");
        sb.append(this.getPathValue());
        sb.append("; HTTP method: ");
        sb.append(this.getHttpMethod());
        sb.append("; produces media type: ");
        sb.append(this.produces());
        sb.append("; consumes media type: ");
        sb.append(this.consumes());
        sb.append("; return type: ");
        sb.append(this.getResponseType());
        sb.append(" ]");
        return sb.toString();
    }
}

