/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.EventObject;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ApplicationContext;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.util.Logger;
import org.everrest.core.util.Tracer;

public class ContainerResponse
implements GenericContainerResponse {
    private static final Logger LOG = Logger.getLogger(ContainerResponse.class);
    private ContainerResponseWriter responseWriter;
    private int status;
    private Type entityType;
    private Object entity;
    private MultivaluedMap<String, Object> headers;
    private MediaType contentType;
    private Response response;

    public ContainerResponse(ContainerResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
        if (response == null) {
            this.status = 0;
            this.entity = null;
            this.entityType = null;
            this.headers = null;
            this.contentType = null;
        } else {
            this.status = response.getStatus();
            this.headers = response.getMetadata();
            this.entity = response.getEntity();
            if (this.entity instanceof GenericEntity) {
                GenericEntity ge = (GenericEntity)this.entity;
                this.entity = ge.getEntity();
                this.entityType = ge.getType();
            } else if (this.entity != null) {
                this.entityType = this.entity.getClass();
            }
            Object contentTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
            this.contentType = contentTypeHeader instanceof MediaType ? (MediaType)contentTypeHeader : (contentTypeHeader != null ? MediaType.valueOf((String)contentTypeHeader.toString()) : null);
        }
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void writeResponse() throws IOException {
        Object entityWriter;
        if (this.entity == null) {
            if (Tracer.isTracingEnabled()) {
                Tracer.addTraceHeaders(this);
            }
            this.responseWriter.writeHeaders(this);
            return;
        }
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        MediaType contentType = this.getContentType();
        if (contentType == null) {
            List<MediaType> availableWriters = context.getProviders().getAcceptableWriterMediaTypes(this.entity.getClass(), this.entityType, null);
            contentType = context.getContainerRequest().getAcceptableMediaType(availableWriters);
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            this.contentType = contentType;
            this.getHttpHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((entityWriter = context.getProviders().getMessageBodyWriter(this.entity.getClass(), this.entityType, null, contentType)) == null) {
            String message = "Not found writer for " + this.entity.getClass() + " and MIME type " + contentType;
            if (context.getContainerRequest().getMethod().equals("HEAD")) {
                LOG.warn(message);
                this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(-1L));
            } else {
                LOG.error(message);
                Response notAcceptableResponse = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)message).type("text/plain").build();
                this.setResponse(notAcceptableResponse);
                entityWriter = context.getProviders().getMessageBodyWriter(String.class, null, null, contentType);
            }
        } else {
            long contentLength;
            if (Tracer.isTracingEnabled()) {
                Tracer.trace("Matched MessageBodyWriter for type " + this.entity.getClass() + ", media type " + contentType + " = (" + entityWriter + ")");
            }
            if (this.getHttpHeaders().getFirst((Object)"Content-Length") == null && (contentLength = entityWriter.getSize(this.entity, this.entity.getClass(), this.entityType, null, contentType)) >= 0L) {
                this.getHttpHeaders().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
            }
        }
        if (context.getContainerRequest().getMethod().equals("HEAD")) {
            this.entity = null;
        }
        OutputListener headersWriter = new OutputListener(){
            private boolean done;

            @Override
            public void onChange(EventObject event) throws IOException {
                if (!this.done) {
                    this.done = true;
                    ContainerResponse.this.responseWriter.writeHeaders(ContainerResponse.this);
                }
            }
        };
        if (Tracer.isTracingEnabled()) {
            Tracer.addTraceHeaders(this);
        }
        this.responseWriter.writeBody(this, new BodyWriter((MessageBodyWriter<Object>)entityWriter, headersWriter));
        headersWriter.onChange(null);
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public MultivaluedMap<String, Object> getHttpHeaders() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    private static interface OutputListener {
        public void onChange(EventObject var1) throws IOException;
    }

    private static class NotifiesOutputStream
    extends OutputStream {
        OutputStream delegate;
        OutputListener writeListener;

        public NotifiesOutputStream(OutputStream output, OutputListener writeListener) {
            this.delegate = output;
            this.writeListener = writeListener;
        }

        @Override
        public void write(int b) throws IOException {
            this.writeListener.onChange(null);
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.writeListener.onChange(null);
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.writeListener.onChange(null);
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.writeListener.onChange(null);
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.writeListener.onChange(null);
            this.delegate.close();
        }
    }

    private static class BodyWriter
    implements MessageBodyWriter<Object> {
        private final MessageBodyWriter<Object> delegate;
        private final OutputListener writeListener;

        public BodyWriter(MessageBodyWriter<Object> writer, OutputListener writeListener) {
            this.delegate = writer;
            this.writeListener = writeListener;
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.delegate.isWriteable(type, genericType, annotations, mediaType);
        }

        public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return this.delegate.getSize(t, type, genericType, annotations, mediaType);
        }

        public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            this.delegate.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, (OutputStream)new NotifiesOutputStream(entityStream, this.writeListener));
        }
    }
}

