/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ConstructorDescriptor;
import org.everrest.core.FieldInjector;
import org.everrest.core.ObjectModel;
import org.everrest.core.impl.ConstructorDescriptorImpl;
import org.everrest.core.impl.FieldInjectorImpl;
import org.everrest.core.impl.MultivaluedMapImpl;

public abstract class BaseObjectModel
implements ObjectModel {
    protected final Class<?> clazz;
    protected MultivaluedMapImpl properties;
    protected final List<ConstructorDescriptor> constructors;
    protected final List<FieldInjector> fields;

    public BaseObjectModel(Class<?> clazz) {
        this.clazz = clazz;
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
        this.processConstructors();
        this.processFields();
    }

    protected void processConstructors() {
        for (Constructor<?> constructor : this.clazz.getConstructors()) {
            this.constructors.add(new ConstructorDescriptorImpl(this.clazz, constructor));
        }
        if (this.constructors.size() == 0) {
            String msg = "Not found accepted constructors for provider class " + this.clazz.getName();
            throw new RuntimeException(msg);
        }
        if (this.constructors.size() > 1) {
            Collections.sort(this.constructors, ConstructorDescriptorImpl.CONSTRUCTOR_COMPARATOR);
        }
    }

    protected void processFields() {
        for (Field jField : this.clazz.getDeclaredFields()) {
            this.fields.add(new FieldInjectorImpl(this.clazz, jField));
        }
        for (Class<?> sc = this.clazz.getSuperclass(); sc != null && sc != Object.class; sc = sc.getSuperclass()) {
            for (Field jField : sc.getDeclaredFields()) {
                FieldInjectorImpl inj = new FieldInjectorImpl(this.clazz, jField);
                if (inj.getAnnotation() == null) continue;
                this.fields.add(inj);
            }
        }
    }

    public BaseObjectModel(Object instance) {
        this.clazz = instance.getClass();
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
    }

    @Override
    public Class<?> getObjectClass() {
        return this.clazz;
    }

    @Override
    public List<ConstructorDescriptor> getConstructorDescriptors() {
        return this.constructors;
    }

    @Override
    public List<FieldInjector> getFieldInjectors() {
        return this.fields;
    }

    @Override
    public MultivaluedMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new MultivaluedMapImpl();
        }
        return this.properties;
    }

    @Override
    public List<String> getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }
}

