/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.impl.OutputHeadersMap;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.header.Language;
import org.everrest.core.util.CaselessMultivaluedMap;
import org.everrest.core.util.CaselessStringWrapper;

public final class ResponseImpl
extends Response {
    private final int status;
    private final Object entity;
    private Annotation[] entityAnnotations;
    private final MultivaluedMap<String, Object> headers;
    private boolean closed;

    ResponseImpl(int status, Object entity, Annotation[] entityAnnotations, MultivaluedMap<String, Object> headers) {
        this.status = status;
        this.entity = entity;
        this.entityAnnotations = entityAnnotations;
        this.headers = headers;
    }

    public Object getEntity() {
        this.failIfClosed();
        return this.entity;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public <T> T readEntity(Class<T> entityType) {
        return this.doReadEntity(entityType, null, null);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return this.doReadEntity(entityType.getRawType(), entityType.getType(), null);
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.doReadEntity(entityType, null, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.doReadEntity(entityType.getRawType(), entityType.getType(), annotations);
    }

    private <T> T doReadEntity(Class<T> type, Type genericType, Annotation[] annotations) {
        this.failIfClosed();
        if (this.entity == null) {
            throw new IllegalStateException("Reading for null entity isn't supported");
        }
        throw new IllegalStateException("Reading for null entity " + this.entity.getClass() + " supported");
    }

    public boolean hasEntity() {
        this.failIfClosed();
        return this.entity != null;
    }

    public boolean bufferEntity() {
        this.failIfClosed();
        return false;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void failIfClosed() {
        if (this.closed) {
            throw new IllegalArgumentException("Response already closed");
        }
    }

    public MediaType getMediaType() {
        Object value = this.getMetadata().getFirst((Object)"Content-Type");
        if (value == null) {
            return null;
        }
        if (value instanceof MediaType) {
            return (MediaType)value;
        }
        return MediaType.valueOf((String)(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value)));
    }

    public Locale getLanguage() {
        Object value = this.getMetadata().getFirst((Object)"Content-Language");
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        return Language.getLocale(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value));
    }

    public int getLength() {
        Object value = this.getMetadata().getFirst((Object)"Content-Length");
        if (value == null) {
            return -1;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value));
    }

    public Set<String> getAllowedMethods() {
        List allowed = (List)this.getMetadata().get((Object)"Allow");
        if (allowed == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> allowedSet = new LinkedHashSet<String>();
        for (Object value : allowed) {
            if (value instanceof String) {
                for (String s : ((String)value).split(",")) {
                    if (s.trim().isEmpty()) continue;
                    allowedSet.add(s.toUpperCase());
                }
                continue;
            }
            if (value == null) continue;
            allowedSet.add(HeaderHelper.getHeaderAsString(value).toUpperCase());
        }
        return allowedSet;
    }

    public Map<String, NewCookie> getCookies() {
        return null;
    }

    public EntityTag getEntityTag() {
        Object value = this.getMetadata().getFirst((Object)"ETag");
        if (value == null) {
            return null;
        }
        if (value instanceof EntityTag) {
            return (EntityTag)value;
        }
        return EntityTag.valueOf((String)(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value)));
    }

    public Date getDate() {
        return this.getDateHeader("Date");
    }

    public Date getLastModified() {
        return this.getDateHeader("Last-Modified");
    }

    private Date getDateHeader(String name) {
        Object value = this.getMetadata().getFirst((Object)name);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return HeaderHelper.parseDateHeader(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value));
    }

    public URI getLocation() {
        Object value = this.getMetadata().getFirst((Object)"Content-Length");
        if (value == null) {
            return null;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        return URI.create(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value));
    }

    public Set<Link> getLinks() {
        List links = (List)this.getMetadata().get((Object)"Link");
        if (links == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Link> linkSet = new LinkedHashSet<Link>();
        for (Object value : links) {
            if (value instanceof Link) {
                linkSet.add((Link)value);
                continue;
            }
            linkSet.add(Link.valueOf((String)(value instanceof String ? (String)value : HeaderHelper.getHeaderAsString(value))));
        }
        return linkSet;
    }

    public boolean hasLink(String relation) {
        for (Link link : this.getLinks()) {
            if (!link.getRels().contains(relation)) continue;
            return true;
        }
        return false;
    }

    public Link getLink(String relation) {
        for (Link link : this.getLinks()) {
            if (!link.getRels().contains(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        CaselessMultivaluedMap<String> headerStrings = new CaselessMultivaluedMap<String>();
        for (Map.Entry entry : this.getMetadata().entrySet()) {
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (Object value : values) {
                headerStrings.add((String)entry.getKey(), HeaderHelper.getHeaderAsString(value));
            }
        }
        return headerStrings;
    }

    public String getHeaderString(String name) {
        List headers = (List)this.getMetadata().get((Object)name);
        if (headers == null) {
            return null;
        }
        LinkedList<String> headerStrings = new LinkedList<String>();
        for (Object header : headers) {
            headerStrings.add(HeaderHelper.getHeaderAsString(header));
        }
        return HeaderHelper.convertToString(headerStrings);
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        Response.Status statusInstance = Response.Status.fromStatusCode((int)this.status);
        if (statusInstance != null) {
            return statusInstance;
        }
        return new Response.StatusType(){

            public int getStatusCode() {
                return ResponseImpl.this.status;
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)ResponseImpl.this.status);
            }

            public String getReasonPhrase() {
                return "Unknown";
            }
        };
    }

    public static final class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private static final Map<CaselessStringWrapper, HEADERS> HEADER_TO_ENUM = new HashMap<CaselessStringWrapper, HEADERS>();
        private static final int DEFAULT_HTTP_STATUS;
        private int status = DEFAULT_HTTP_STATUS;
        private Object entity;
        private Annotation[] entityAnnotations;
        private final ExtMultivaluedMap<String, Object> headers = new CaselessMultivaluedMap<Object>();
        private final Map<String, NewCookie> cookies = new HashMap<String, NewCookie>();

        ResponseBuilderImpl() {
        }

        private ResponseBuilderImpl(ResponseBuilderImpl other) {
            this.status = other.status;
            this.entity = other.entity;
            this.headers.putAll((Map)((Object)other.headers));
            this.cookies.putAll(other.cookies);
            if (other.entityAnnotations != null) {
                this.entityAnnotations = new Annotation[other.entityAnnotations.length];
                System.arraycopy(other.entityAnnotations, 0, this.entityAnnotations, 0, this.entityAnnotations.length);
            }
        }

        public Response build() {
            OutputHeadersMap m = new OutputHeadersMap((Map<String, List<Object>>)((Object)this.headers));
            if (this.cookies.size() > 0) {
                for (NewCookie c : this.cookies.values()) {
                    m.add("Set-Cookie", c);
                }
            }
            ResponseImpl response = new ResponseImpl(this.status, this.entity, this.entityAnnotations, m);
            this.reset();
            return response;
        }

        private void reset() {
            this.status = DEFAULT_HTTP_STATUS;
            this.entity = null;
            this.entityAnnotations = null;
            this.headers.clear();
            this.cookies.clear();
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            this.headers.putSingle("Cache-Control", cacheControl);
            return this;
        }

        public Response.ResponseBuilder encoding(String encoding) {
            if (encoding == null) {
                this.headers.remove("Content-Encoding");
            } else {
                this.headers.putSingle("Content-Encoding", encoding);
            }
            return this;
        }

        public Response.ResponseBuilder clone() {
            return new ResponseBuilderImpl(this);
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            if (location == null) {
                this.headers.remove("Content-Location");
            } else {
                this.headers.putSingle("Content-Location", location);
            }
            return this;
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            if (cookies == null) {
                this.cookies.clear();
                this.headers.remove("Set-Cookie");
            } else {
                for (NewCookie c : cookies) {
                    this.cookies.put(c.getName(), c);
                }
            }
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
            this.entity = entity;
            this.entityAnnotations = annotations;
            return this;
        }

        public Response.ResponseBuilder allow(String ... methods) {
            if (methods == null) {
                this.headers.remove("Allow");
            } else {
                Collections.addAll(this.headers.getList("Allow"), methods);
            }
            return this;
        }

        public Response.ResponseBuilder allow(Set<String> methods) {
            if (methods == null) {
                this.headers.remove("Allow");
            } else {
                this.headers.getList("Allow").addAll(methods);
            }
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            if (expires == null) {
                this.headers.remove("Expires");
            } else {
                this.headers.putSingle("Expires", expires);
            }
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            if (value == null) {
                this.headers.remove(name);
            } else if (HEADER_TO_ENUM.get(new CaselessStringWrapper(name)) != null) {
                this.headers.putSingle(name, value);
            } else {
                this.headers.add(name, value);
            }
            return this;
        }

        public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
            this.headers.clear();
            if (headers != null) {
                this.headers.putAll((Map)headers);
            }
            return this;
        }

        public Response.ResponseBuilder language(String language) {
            if (language == null) {
                this.headers.remove("Content-Language");
            } else {
                this.headers.putSingle("Content-Language", language);
            }
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            if (language == null) {
                this.headers.remove("Content-Language");
            } else {
                this.headers.putSingle("Content-Language", language);
            }
            return this;
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            if (lastModified == null) {
                this.headers.remove("Last-Modified");
            } else {
                this.headers.putSingle("Last-Modified", lastModified);
            }
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            if (location == null) {
                this.headers.remove("Location");
            } else {
                this.headers.putSingle("Location", location);
            }
            return this;
        }

        public Response.ResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            if (tag == null) {
                this.headers.remove("ETag");
            } else {
                this.headers.putSingle("ETag", tag);
            }
            return this;
        }

        public Response.ResponseBuilder tag(String tag) {
            if (tag == null) {
                this.headers.remove("ETag");
            } else {
                this.headers.putSingle("ETag", tag);
            }
            return this;
        }

        public Response.ResponseBuilder variants(Variant ... variants) {
            return this.variants(variants == null ? null : Arrays.asList(variants));
        }

        public Response.ResponseBuilder type(MediaType type) {
            if (type == null) {
                this.headers.remove("Content-Type");
            } else {
                this.headers.putSingle("Content-Type", type);
            }
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            if (type == null) {
                this.headers.remove("Content-Type");
            } else {
                this.headers.putSingle("Content-Type", type);
            }
            return this;
        }

        public Response.ResponseBuilder variant(Variant variant) {
            if (variant == null) {
                variant = new Variant(null, (String)null, null);
            }
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            if (variant.getEncoding() != null) {
                this.header("Content-Encoding", variant.getEncoding());
            }
            return this;
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            if (variants == null) {
                this.headers.remove("Vary");
                return this;
            }
            if (variants.isEmpty()) {
                return this;
            }
            boolean acceptMediaType = variants.get(0).getMediaType() != null;
            boolean acceptLanguage = variants.get(0).getLanguage() != null;
            boolean acceptEncoding = variants.get(0).getEncoding() != null;
            for (Variant v : variants) {
                acceptMediaType |= v.getMediaType() != null;
                acceptLanguage |= v.getLanguage() != null;
                acceptEncoding |= v.getEncoding() != null;
            }
            StringBuilder sb = new StringBuilder();
            if (acceptMediaType) {
                sb.append("Accept");
            }
            if (acceptLanguage) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Language");
            }
            if (acceptEncoding) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Encoding");
            }
            if (sb.length() > 0) {
                this.header("Vary", sb.toString());
            }
            return this;
        }

        public Response.ResponseBuilder links(Link ... links) {
            if (links == null) {
                this.headers.remove("Link");
            } else {
                Collections.addAll(this.headers.getList("Link"), links);
            }
            return this;
        }

        public Response.ResponseBuilder link(URI uri, String rel) {
            this.headers.getList("Link").add(Link.fromUri((URI)uri).rel(rel));
            return this;
        }

        public Response.ResponseBuilder link(String uri, String rel) {
            return this.link(URI.create(uri), rel);
        }

        static {
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Cache-Control"), HEADERS.CACHE_CONTROL);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Language"), HEADERS.CONTENT_LANGUAGE);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Location"), HEADERS.CONTENT_LOCATION);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Type"), HEADERS.CONTENT_TYPE);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Content-Length"), HEADERS.CONTENT_LENGTH);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("ETag"), HEADERS.ETAG);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Last-Modified"), HEADERS.LAST_MODIFIED);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Location"), HEADERS.LOCATION);
            HEADER_TO_ENUM.put(new CaselessStringWrapper("Expires"), HEADERS.EXPIRES);
            DEFAULT_HTTP_STATUS = Response.Status.NO_CONTENT.getStatusCode();
        }

        private static enum HEADERS {
            CACHE_CONTROL,
            CONTENT_LANGUAGE,
            CONTENT_LOCATION,
            CONTENT_TYPE,
            CONTENT_LENGTH,
            ETAG,
            EXPIRES,
            LAST_MODIFIED,
            LOCATION;

        }
    }
}

