/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.everrest.core.Property;
import org.everrest.core.impl.method.CollectionStringConstructorProducer;
import org.everrest.core.impl.method.CollectionStringProducer;
import org.everrest.core.impl.method.CollectionStringValueOfProducer;
import org.everrest.core.impl.method.PrimitiveTypeProducer;
import org.everrest.core.impl.method.StringConstructorProducer;
import org.everrest.core.impl.method.StringProducer;
import org.everrest.core.impl.method.StringValueOfProducer;
import org.everrest.core.method.TypeProducer;

public class ParameterHelper {
    public static final List<String> PROVIDER_FIELDS_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList(Context.class.getName(), Property.class.getName()));
    public static final List<String> PROVIDER_CONSTRUCTOR_PARAMETER_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList(Context.class.getName(), Property.class.getName()));
    public static final List<String> RESOURCE_FIELDS_ANNOTATIONS;
    public static final List<String> RESOURCE_CONSTRUCTOR_PARAMETER_ANNOTATIONS;
    public static final List<String> RESOURCE_METHOD_PARAMETER_ANNOTATIONS;

    static TypeProducer createTypeProducer(Class<?> parameterClass, Type parameterType) {
        if (parameterClass == List.class || parameterClass == Set.class || parameterClass == SortedSet.class) {
            Class<?> clazz = null;
            if (parameterType != null) {
                clazz = ParameterHelper.getGenericType(parameterType);
            }
            if (clazz == String.class || clazz == null) {
                return new CollectionStringProducer(parameterClass);
            }
            Method methodValueOf = ParameterHelper.getStringValueOfMethod(clazz);
            if (methodValueOf != null) {
                return new CollectionStringValueOfProducer(parameterClass, methodValueOf);
            }
            Constructor<?> constructor = ParameterHelper.getStringConstructor(clazz);
            if (constructor != null) {
                return new CollectionStringConstructorProducer(parameterClass, constructor);
            }
        } else {
            if (parameterClass.isPrimitive()) {
                return new PrimitiveTypeProducer(parameterClass);
            }
            if (parameterClass == String.class) {
                return new StringProducer();
            }
            Method methodValueOf = ParameterHelper.getStringValueOfMethod(parameterClass);
            if (methodValueOf != null) {
                return new StringValueOfProducer(methodValueOf);
            }
            Constructor<?> constructor = ParameterHelper.getStringConstructor(parameterClass);
            if (constructor != null) {
                return new StringConstructorProducer(constructor);
            }
        }
        return null;
    }

    static Method getStringValueOfMethod(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static Constructor<?> getStringConstructor(Class<?> clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Class<?> getGenericType(Type type) {
        ParameterizedType pt;
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = (pt = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            try {
                return (Class)genericTypes[0];
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Unsupported type");
            }
        }
        return null;
    }

    static {
        ArrayList<String> tmp1 = new ArrayList<String>(7);
        tmp1.add(CookieParam.class.getName());
        tmp1.add(Context.class.getName());
        tmp1.add(HeaderParam.class.getName());
        tmp1.add(MatrixParam.class.getName());
        tmp1.add(PathParam.class.getName());
        tmp1.add(QueryParam.class.getName());
        tmp1.add(Property.class.getName());
        RESOURCE_FIELDS_ANNOTATIONS = Collections.unmodifiableList(tmp1);
        RESOURCE_CONSTRUCTOR_PARAMETER_ANNOTATIONS = Collections.unmodifiableList(tmp1);
        ArrayList<String> tmp2 = new ArrayList<String>(tmp1);
        tmp2.add(FormParam.class.getName());
        RESOURCE_METHOD_PARAMETER_ANNOTATIONS = Collections.unmodifiableList(tmp2);
    }
}

