/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.everrest.core.impl.FileCollector;

public final class IOHelper {
    static final String DEFAULT_CHARSET_NAME = "UTF-8";
    static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private IOHelper() {
    }

    public static void write(InputStream in, OutputStream out) throws IOException {
        int rd;
        byte[] buf = new byte[1024];
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    public static void write(Reader in, Writer out) throws IOException {
        int rd;
        char[] buf = new char[1024];
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    public static String readString(InputStream in, String cs) throws IOException {
        int rd;
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        InputStreamReader r = new InputStreamReader(in, charset);
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((rd = r.read(buf)) != -1) {
            sb.append(buf, 0, rd);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String s, OutputStream out, String cs) throws IOException {
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        OutputStreamWriter w = new OutputStreamWriter(out, charset);
        try {
            w.write(s);
        }
        finally {
            ((Writer)w).flush();
        }
    }

    public static InputStream bufferStream(InputStream in, int maxMemSize) throws IOException {
        int r;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[8192];
        boolean overflow = false;
        while (!overflow && (r = in.read(b)) != -1) {
            bos.write(b, 0, r);
            overflow = bos.size() > maxMemSize;
        }
        if (overflow) {
            File f = FileCollector.getInstance().createFile();
            try (FileOutputStream fos = new FileOutputStream(f);){
                bos.writeTo(fos);
                while ((r = in.read(b)) != -1) {
                    fos.write(b, 0, r);
                }
            }
            return new DeleteOnCloseFIS(f);
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private static final class DeleteOnCloseFIS
    extends FileInputStream {
        private final File file;

        public DeleteOnCloseFIS(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file.exists()) {
                    this.file.delete();
                }
            }
        }
    }
}

