/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Provider
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class XSLTTemplatesContextResolver
implements ContextResolver<XSLTTemplatesContextResolver> {
    private final Map<String, Templates> templates = new HashMap<String, Templates>();
    private EntityResolver resolver;

    public XSLTTemplatesContextResolver getContext(Class<?> type) {
        return this;
    }

    public void setXmlResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsTemplate(String name, Source source) throws IOException, SAXException, TransformerConfigurationException {
        if (this.templates.get(name) != null) {
            throw new IllegalArgumentException("Template with name '" + name + "' already registered. ");
        }
        Map<String, Templates> map = this.templates;
        synchronized (map) {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            TemplatesHandler templateHandler = factory.newTemplatesHandler();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            if (this.resolver != null) {
                xmlReader.setEntityResolver(this.resolver);
            }
            xmlReader.setContentHandler(templateHandler);
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            if (inputSource == null) {
                throw new RuntimeException("Unable convert to Input Source.");
            }
            xmlReader.parse(inputSource);
            Templates t = templateHandler.getTemplates();
            if (t == null) {
                throw new RuntimeException("Unable create templates from given source. ");
            }
            this.templates.put(name, t);
        }
    }

    public Templates getTemplates(String name) {
        return this.templates.get(name);
    }
}

