/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.everrest.core.provider.EntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Provider
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class DOMSourceEntityProvider
implements EntityProvider<DOMSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DOMSourceEntityProvider.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == DOMSource.class;
    }

    public DOMSource readFrom(Class<DOMSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().parse(entityStream);
            return new DOMSource(d);
        }
        catch (SAXParseException saxpe) {
            if (LOG.isDebugEnabled()) {
                LOG.error(saxpe.getMessage(), (Throwable)saxpe);
            }
            return null;
        }
        catch (SAXException saxe) {
            throw new IOException("Can't read from input stream " + saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Can't read from input stream " + pce);
        }
    }

    public long getSize(DOMSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DOMSource.class.isAssignableFrom(type);
    }

    public void writeTo(DOMSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        StreamResult out = new StreamResult(entityStream);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.newTransformer().transform(t, out);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Can't write to output stream " + e);
        }
        catch (TransformerException e) {
            throw new IOException("Can't write to output stream " + e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException("Can't write to output stream " + e);
        }
    }
}

