/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.impl.provider.multipart.BaseMultipartFormDataWriter;
import org.everrest.core.impl.provider.multipart.OutputItem;

@Provider
@Produces(value={"multipart/*"})
public class CollectionMultipartFormDataMessageBodyWriter
extends BaseMultipartFormDataWriter
implements MessageBodyWriter<Collection<OutputItem>> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)genericType;
            Type[] ta = t.getActualTypeArguments();
            return ta.length == 1 && ta[0] instanceof Class && OutputItem.class.isAssignableFrom((Class)ta[0]);
        }
        return false;
    }

    public long getSize(Collection<OutputItem> items, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Collection<OutputItem> items, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = Long.toString(System.currentTimeMillis());
        }
        httpHeaders.putSingle((Object)"Content-type", (Object)(mediaType.toString() + "; boundary=" + boundary));
        byte[] boundaryBytes = boundary.getBytes();
        this.writeItems(items, entityStream, boundaryBytes);
    }
}

