/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method;

import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.everrest.core.ApplicationContext;
import org.everrest.core.Parameter;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.method.ParameterHelper;
import org.everrest.core.impl.method.ParameterResolver;
import org.everrest.core.method.TypeProducer;

public class FormParameterResolver
extends ParameterResolver<FormParam> {
    private static final Type FORM_TYPE = (ParameterizedType)MultivaluedMapImpl.class.getGenericInterfaces()[0];
    private final FormParam formParam;

    FormParameterResolver(FormParam formParam) {
        this.formParam = formParam;
    }

    @Override
    public Object resolve(Parameter parameter, ApplicationContext context) throws Exception {
        String param = this.formParam.value();
        TypeProducer typeProducer = ParameterHelper.createTypeProducer(parameter.getParameterClass(), parameter.getGenericType());
        MediaType contentType = context.getHttpHeaders().getMediaType();
        MessageBodyReader<MultivaluedMap> reader = context.getProviders().getMessageBodyReader(MultivaluedMap.class, FORM_TYPE, null, contentType);
        if (reader == null) {
            throw new IllegalStateException("Can't find appropriate entity reader for entity type " + MultivaluedMap.class.getName() + " and content-type " + contentType);
        }
        try (InputStream entityStream = context.getContainerRequest().getEntityStream();){
            MultivaluedMap form = (MultivaluedMap)reader.readFrom(MultivaluedMap.class, FORM_TYPE, null, contentType, context.getHttpHeaders().getRequestHeaders(), entityStream);
            Object object = typeProducer.createValue(param, (MultivaluedMap<String, String>)form, parameter.getDefaultValue());
            return object;
        }
    }
}

