/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;

public class EverrestApplication
extends Application {
    private final Set<ObjectFactory<? extends ObjectModel>> factories;
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Set<Object> singletons = new LinkedHashSet<Object>();
    private final Map<String, Class<?>> resourceClasses;
    private final Map<String, Object> resourceSingletons;

    public EverrestApplication() {
        this.factories = new LinkedHashSet<ObjectFactory<? extends ObjectModel>>();
        this.resourceClasses = new LinkedHashMap();
        this.resourceSingletons = new LinkedHashMap<String, Object>();
    }

    public void addClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    public void addSingleton(Object singleton) {
        this.singletons.add(singleton);
    }

    public void addFactory(ObjectFactory<? extends ObjectModel> factory) {
        this.factories.add(factory);
    }

    public void addResource(String uriPattern, Class<?> resourceClass) {
        this.resourceClasses.put(uriPattern, resourceClass);
    }

    public void addResource(String uriPattern, Object resource) {
        this.resourceSingletons.put(uriPattern, resource);
    }

    public Map<String, Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public Map<String, Object> getResourceSingletons() {
        return this.resourceSingletons;
    }

    public Set<ObjectFactory<? extends ObjectModel>> getFactories() {
        return this.factories;
    }

    public Set<Class<?>> getClasses() {
        LinkedHashSet myClasses = new LinkedHashSet(this.classes);
        for (ObjectFactory<? extends ObjectModel> factory : this.getFactories()) {
            myClasses.add(factory.getObjectModel().getObjectClass());
        }
        return myClasses;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void addApplication(Application application) {
        if (application != null) {
            Set appClasses;
            Set appSingletons = application.getSingletons();
            if (appSingletons != null && appSingletons.size() > 0) {
                LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(this.singletons.size() + appSingletons.size());
                tmp.addAll(appSingletons);
                tmp.addAll(this.singletons);
                this.singletons.clear();
                this.singletons.addAll(tmp);
            }
            if ((appClasses = application.getClasses()) != null && appClasses.size() > 0) {
                LinkedHashSet tmp = new LinkedHashSet(this.classes.size() + appClasses.size());
                tmp.addAll(appClasses);
                tmp.addAll(this.classes);
                this.classes.clear();
                this.classes.addAll(tmp);
            }
            if (application instanceof EverrestApplication) {
                EverrestApplication everrest = (EverrestApplication)application;
                Set<ObjectFactory<? extends ObjectModel>> appFactories = everrest.getFactories();
                LinkedHashSet<ObjectFactory<? extends ObjectModel>> tmp1 = new LinkedHashSet<ObjectFactory<? extends ObjectModel>>(this.factories.size() + appFactories.size());
                tmp1.addAll(appFactories);
                tmp1.addAll(this.factories);
                this.factories.clear();
                this.factories.addAll(tmp1);
                Map<String, Class<?>> appResourceClasses = everrest.getResourceClasses();
                LinkedHashMap tmp2 = new LinkedHashMap(this.resourceClasses.size() + appResourceClasses.size());
                tmp2.putAll(appResourceClasses);
                tmp2.putAll(this.resourceClasses);
                this.resourceClasses.clear();
                this.resourceClasses.putAll(tmp2);
                Map<String, Object> appResourceSingletons = everrest.getResourceSingletons();
                LinkedHashMap<String, Object> tmp3 = new LinkedHashMap<String, Object>(this.resourceSingletons.size() + appResourceSingletons.size());
                tmp3.putAll(appResourceSingletons);
                tmp3.putAll(this.resourceSingletons);
                this.resourceSingletons.clear();
                this.resourceSingletons.putAll(tmp3);
            }
        }
    }
}

