/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.servlet.ServletContainerRequest;
import org.everrest.core.servlet.ServletContainerResponseWriter;
import org.everrest.core.tools.ErrorPages;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.everrest.core.util.Logger;

public class EverrestServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(EverrestServlet.class.getName());
    private WebApplicationDeclaredRoles webApplicationRoles;
    private ErrorPages errorPages;
    protected EverrestProcessor processor;

    public void init() throws ServletException {
        this.processor = (EverrestProcessor)this.getServletConfig().getServletContext().getAttribute(EverrestProcessor.class.getName());
        this.webApplicationRoles = new WebApplicationDeclaredRoles(this.getServletContext());
        this.errorPages = new ErrorPages(this.getServletContext());
    }

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        EnvironmentContext env = new EnvironmentContext();
        env.put(HttpServletRequest.class, httpRequest);
        env.put(HttpServletResponse.class, httpResponse);
        env.put(ServletConfig.class, this.getServletConfig());
        ServletContext servletContext = this.getServletContext();
        env.put(ServletContext.class, servletContext);
        env.put(WebApplicationDeclaredRoles.class, this.webApplicationRoles);
        env.put(ErrorPages.class, this.errorPages);
        try {
            ServletContainerRequest request = ServletContainerRequest.create(httpRequest);
            ContainerResponse response = new ContainerResponse(new ServletContainerResponseWriter(httpResponse));
            this.processor.process(request, response, env);
        }
        catch (IOException ioe) {
            if (ioe.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ioe.getMessage(), ioe);
                }
            }
            throw ioe;
        }
        catch (UnhandledException e) {
            LOG.error(e.getMessage(), e);
            throw new ServletException(e.getCause());
        }
    }
}

