/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.Lifecycle;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;
import org.everrest.core.impl.method.MethodInvokerDecoratorFactory;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.util.Logger;
import org.everrest.core.util.Tracer;

public final class EverrestProcessor
implements Lifecycle {
    private static final Logger LOG = Logger.getLogger(EverrestProcessor.class.getName());
    private final ResourceBinder resources;
    private final ProviderBinder providers;
    private final DependencySupplier dependencySupplier;
    private final RequestHandler requestHandler;
    private final Deployer deployer;
    private final EverrestConfiguration config;
    private final MethodInvokerDecoratorFactory methodInvokerDecoratorFactory;
    private final Map<String, String> properties;

    public EverrestProcessor(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencySupplier, EverrestConfiguration config, Application application) {
        this.resources = resources;
        this.providers = providers;
        this.dependencySupplier = dependencySupplier;
        this.requestHandler = new RequestHandlerImpl(new RequestDispatcher(resources));
        this.properties = new ConcurrentHashMap<String, String>();
        this.config = config == null ? new EverrestConfiguration() : config;
        String decoratorFactoryClassName = this.config.getProperty("org.everrest.core.impl.method.MethodInvokerDecoratorFactory");
        if (decoratorFactoryClassName != null) {
            try {
                this.methodInvokerDecoratorFactory = (MethodInvokerDecoratorFactory)MethodInvokerDecoratorFactory.class.cast(Thread.currentThread().getContextClassLoader().loadClass(decoratorFactoryClassName).newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot instantiate '" + decoratorFactoryClassName + "', : " + e, e);
            }
        } else {
            this.methodInvokerDecoratorFactory = null;
        }
        this.deployer = new Deployer(resources, providers);
        if (application != null) {
            this.deployer.addApplication(application);
        }
    }

    public EverrestProcessor(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencySupplier) {
        this(resources, providers, dependencySupplier, null, null);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GenericContainerRequest request, GenericContainerResponse response, EnvironmentContext envCtx) throws UnhandledException, IOException {
        EnvironmentContext.setCurrent(envCtx);
        ApplicationContextImpl context = null;
        try {
            String method;
            context = new ApplicationContextImpl(request, response, this.providers, this.methodInvokerDecoratorFactory);
            context.getProperties().putAll(this.properties);
            context.setDependencySupplier(this.dependencySupplier);
            context.setApplication(this.deployer);
            context.setEverrestConfiguration(new EverrestConfiguration(this.config));
            context.start();
            ApplicationContextImpl.setCurrent(context);
            if (this.config.isNormalizeUri()) {
                request.setUris(UriComponent.normalize(request.getRequestUri()), request.getBaseUri());
            }
            if (this.config.isHttpMethodOverride() && (method = (String)request.getRequestHeaders().getFirst((Object)"X-HTTP-Method-Override")) != null) {
                if (Tracer.isTracingEnabled()) {
                    Tracer.trace("Override HTTP method from \"X-HTTP-Method-Override\" header " + request.getMethod() + " => " + method);
                }
                request.setMethod(method);
            }
            this.requestHandler.handleRequest(request, response);
        }
        finally {
            try {
                if (context != null) {
                    context.stop();
                }
            }
            finally {
                ApplicationContextImpl.setCurrent(null);
            }
            EnvironmentContext.setCurrent(null);
        }
    }

    public void addApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("application");
        }
        this.deployer.addApplication(application);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.deployer.stop();
    }

    public ProviderBinder getProviders() {
        return this.providers;
    }

    public ResourceBinder getResources() {
        return this.resources;
    }

    private static class Deployer
    extends EverrestApplication {
        final ApplicationPublisher publisher;
        final List<WeakReference<Object>> singletonsReferences;

        Deployer(ResourceBinder resources, ProviderBinder providers) {
            this.publisher = new ApplicationPublisher(resources, providers);
            this.singletonsReferences = new ArrayList<WeakReference<Object>>();
        }

        @Override
        public void addApplication(Application application) {
            super.addApplication(application);
            this.publisher.publish(application);
            Set singletons = application.getSingletons();
            if (singletons != null && singletons.size() > 0) {
                for (Object o : singletons) {
                    this.singletonsReferences.add(new WeakReference(o));
                }
            }
        }

        void stop() {
            for (WeakReference<Object> ref : this.singletonsReferences) {
                Object o = ref.get();
                if (o == null) continue;
                try {
                    new LifecycleComponent(o).destroy();
                }
                catch (InternalException e) {
                    LOG.error("Unable to destroy component. ", e);
                }
            }
            this.singletonsReferences.clear();
        }
    }
}

