/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ObjectFactory;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResourcePublicationException;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Logger;

public class ResourceBinderImpl
implements ResourceBinder {
    private static final Logger LOG = Logger.getLogger(ResourceBinderImpl.class);
    protected static final Comparator<ObjectFactory<AbstractResourceDescriptor>> RESOURCE_COMPARATOR = new Comparator<ObjectFactory<AbstractResourceDescriptor>>(){

        @Override
        public int compare(ObjectFactory<AbstractResourceDescriptor> o1, ObjectFactory<AbstractResourceDescriptor> o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getObjectModel().getUriPattern(), o2.getObjectModel().getUriPattern());
        }
    };
    private volatile List<ObjectFactory<AbstractResourceDescriptor>> resources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
    private final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        Path path = resourceClass.getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException(String.format("Resource class %s it is not root resource. Path annotation javax.ws.rs.Path is not specified for this class.", resourceClass.getName()));
        }
        try {
            this.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(this.newResourceDescriptor(null, resourceClass, properties)));
        }
        catch (Exception e) {
            if (e instanceof ResourcePublicationException) {
                throw (ResourcePublicationException)e;
            }
            throw new ResourcePublicationException(e.getMessage(), e);
        }
    }

    @Override
    public void addResource(String uriPattern, Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        this.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(this.newResourceDescriptor(uriPattern, resourceClass, properties)));
    }

    private AbstractResourceDescriptor newResourceDescriptor(String path, Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        AbstractResourceDescriptorImpl descriptor = path == null ? new AbstractResourceDescriptorImpl(resourceClass) : new AbstractResourceDescriptorImpl(path, resourceClass);
        descriptor.accept(this.rdv);
        if (properties != null) {
            descriptor.getProperties().putAll(properties);
        }
        return descriptor;
    }

    @Override
    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        Path path = resource.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException(String.format("Resource class %s it is not root resource. Path annotation javax.ws.rs.Path is not specified for this class.", resource.getClass().getName()));
        }
        this.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(this.newResourceDescriptor(null, resource, properties), resource));
    }

    @Override
    public void addResource(String uriPattern, Object resource, MultivaluedMap<String, String> properties) {
        this.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(this.newResourceDescriptor(uriPattern, resource, properties), resource));
    }

    private AbstractResourceDescriptor newResourceDescriptor(String path, Object resource, MultivaluedMap<String, String> properties) {
        AbstractResourceDescriptorImpl descriptor = path == null ? new AbstractResourceDescriptorImpl(resource) : new AbstractResourceDescriptorImpl(path, resource);
        descriptor.accept(this.rdv);
        if (properties != null) {
            descriptor.getProperties().putAll(properties);
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(ObjectFactory<AbstractResourceDescriptor> resourceFactory) {
        UriPattern pattern = resourceFactory.getObjectModel().getUriPattern();
        this.lock.lock();
        try {
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            for (ObjectFactory objectFactory : snapshot) {
                if (!((AbstractResourceDescriptor)objectFactory.getObjectModel()).getUriPattern().equals(resourceFactory.getObjectModel().getUriPattern())) continue;
                if (((AbstractResourceDescriptor)objectFactory.getObjectModel()).getObjectClass() == resourceFactory.getObjectModel().getObjectClass()) {
                    LOG.debug(String.format("Resource %s already registered.", resourceFactory.getObjectModel().getObjectClass().getName()));
                    return;
                }
                throw new ResourcePublicationException(String.format("Resource class %s can't be registered. Resource class %s with the same pattern %s already registered.", resourceFactory.getObjectModel().getObjectClass().getName(), ((AbstractResourceDescriptor)objectFactory.getObjectModel()).getObjectClass().getName(), pattern));
            }
            snapshot.add(resourceFactory);
            Collections.sort(snapshot, RESOURCE_COMPARATOR);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Add resource: " + resourceFactory.getObjectModel());
            }
            this.resources = snapshot;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.resources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ObjectFactory<AbstractResourceDescriptor> getMatchedResource(String requestPath, List<String> parameterValues) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = null;
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        for (ObjectFactory<AbstractResourceDescriptor> resource : myResources) {
            int len;
            if (!resource.getObjectModel().getUriPattern().match(requestPath, parameterValues) || parameterValues.get((len = parameterValues.size()) - 1) != null && !parameterValues.get(len - 1).equals("/") && 0 == resource.getObjectModel().getSubResourceMethods().size() + resource.getObjectModel().getSubResourceLocators().size()) continue;
            resourceFactory = resource;
            break;
        }
        return resourceFactory;
    }

    @Override
    public List<ObjectFactory<AbstractResourceDescriptor>> getResources() {
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        return new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(myResources);
    }

    @Override
    public int getSize() {
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        return myResources.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(Class<?> clazz) {
        this.lock.lock();
        try {
            ObjectFactory resource = null;
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            Iterator iterator = snapshot.iterator();
            while (iterator.hasNext() && resource == null) {
                ObjectFactory next = (ObjectFactory)iterator.next();
                Class<?> resourceClass = ((AbstractResourceDescriptor)next.getObjectModel()).getObjectClass();
                if (!clazz.equals(resourceClass)) continue;
                resource = next;
                iterator.remove();
            }
            if (resource != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
                this.resources = snapshot;
            }
            ObjectFactory objectFactory = resource;
            return objectFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(String path) {
        this.lock.lock();
        try {
            ObjectFactory resource = null;
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            UriPattern pattern = new UriPattern(path);
            Iterator iterator = snapshot.iterator();
            while (iterator.hasNext() && resource == null) {
                ObjectFactory next = (ObjectFactory)iterator.next();
                UriPattern resourcePattern = ((AbstractResourceDescriptor)next.getObjectModel()).getUriPattern();
                if (!pattern.equals(resourcePattern)) continue;
                resource = next;
                iterator.remove();
            }
            if (resource != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
                this.resources = snapshot;
            }
            ObjectFactory objectFactory = resource;
            return objectFactory;
        }
        finally {
            this.lock.unlock();
        }
    }
}

