/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.RuntimeDelegate;

public final class Ranges {
    private static final RuntimeDelegate.HeaderDelegate<Ranges> DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(Ranges.class);
    private final List<Range> ranges;

    public static Ranges valueOf(String range) {
        return (Ranges)DELEGATE.fromString(range);
    }

    Ranges(List<Range> ranges) {
        this.ranges = Collections.unmodifiableList(ranges);
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public static class Range {
        private long start;
        private long end;

        Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public boolean validate(long length) {
            if (this.start < 0L && this.end == -1L) {
                this.start = -1L * this.start >= length ? 0L : length + this.start;
                this.end = length - 1L;
            } else if (this.start >= 0L && this.end == -1L) {
                this.end = length - 1L;
            } else if (this.end >= length) {
                this.end = length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.end >= this.start;
        }
    }
}

