/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonGenerator;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonTransient;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.JsonWriter;
import org.everrest.core.impl.provider.json.ObjectBuilder;
import org.everrest.core.provider.EntityProvider;
import org.everrest.core.util.Logger;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonEntityProvider<T>
implements EntityProvider<T> {
    private static final Logger LOG = Logger.getLogger(JsonEntityProvider.class);
    private static final Class<?>[] IGNORED = new Class[]{byte[].class, char[].class, DataSource.class, DOMSource.class, File.class, InputStream.class, OutputStream.class, JAXBElement.class, MultivaluedMap.class, Reader.class, Writer.class, SAXSource.class, StreamingOutput.class, StreamSource.class, String.class};

    private static boolean isSupported(Class<?> type) {
        if (type.getAnnotation(JsonTransient.class) != null) {
            return false;
        }
        for (Class<?> c : IGNORED) {
            if (!c.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonEntityProvider.isSupported(type);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JsonParser jsonParser = new JsonParser();
            jsonParser.parse(entityStream);
            JsonValue jsonValue = jsonParser.getJsonObject();
            if (JsonValue.class.isAssignableFrom(type)) {
                return (T)jsonValue;
            }
            JsonUtils.Types jType = JsonUtils.getType(type);
            if (jType == JsonUtils.Types.ARRAY_BOOLEAN || jType == JsonUtils.Types.ARRAY_BYTE || jType == JsonUtils.Types.ARRAY_SHORT || jType == JsonUtils.Types.ARRAY_INT || jType == JsonUtils.Types.ARRAY_LONG || jType == JsonUtils.Types.ARRAY_FLOAT || jType == JsonUtils.Types.ARRAY_DOUBLE || jType == JsonUtils.Types.ARRAY_CHAR || jType == JsonUtils.Types.ARRAY_STRING || jType == JsonUtils.Types.ARRAY_OBJECT) {
                return (T)ObjectBuilder.createArray(type, jsonValue);
            }
            if (jType == JsonUtils.Types.COLLECTION) {
                Class<T> c = type;
                return ObjectBuilder.createCollection(c, genericType, jsonValue);
            }
            if (jType == JsonUtils.Types.MAP) {
                Class<T> c = type;
                return ObjectBuilder.createObject(c, genericType, jsonValue);
            }
            return ObjectBuilder.createObject(type, jsonValue);
        }
        catch (JsonException e) {
            LOG.debug(e.getMessage(), e);
            throw new IOException("Can't read from input stream " + e, e);
        }
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonEntityProvider.isSupported(type);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            JsonUtils.Types jType;
            JsonValue jsonValue = t instanceof JsonValue ? (JsonValue)t : ((jType = JsonUtils.getType(type)) == JsonUtils.Types.ARRAY_BOOLEAN || jType == JsonUtils.Types.ARRAY_BYTE || jType == JsonUtils.Types.ARRAY_SHORT || jType == JsonUtils.Types.ARRAY_INT || jType == JsonUtils.Types.ARRAY_LONG || jType == JsonUtils.Types.ARRAY_FLOAT || jType == JsonUtils.Types.ARRAY_DOUBLE || jType == JsonUtils.Types.ARRAY_CHAR || jType == JsonUtils.Types.ARRAY_STRING || jType == JsonUtils.Types.ARRAY_OBJECT ? JsonGenerator.createJsonArray(t) : (jType == JsonUtils.Types.COLLECTION ? JsonGenerator.createJsonArray((Collection)t) : (jType == JsonUtils.Types.MAP ? JsonGenerator.createJsonObjectFromMap((Map)t) : JsonGenerator.createJsonObject(t))));
            JsonWriter jsonWriter = new JsonWriter(entityStream);
            jsonValue.writeTo(jsonWriter);
            jsonWriter.flush();
        }
        catch (JsonException e) {
            LOG.debug(e.getMessage(), e);
            throw new IOException("Can't write to output stream. " + e.getMessage(), e);
        }
    }
}

