/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type ownerType;
    private final Type[] typeArguments;
    private final Class<?> rawType;

    public static ParameterizedType newParameterizedType(Class<?> rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(rawType, typeArguments);
    }

    public static ParameterizedType newParameterizedType(Class<?> rawType, Type typeArgument) {
        return new ParameterizedTypeImpl(rawType, typeArgument);
    }

    private ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type typeArgument) {
        this.ownerType = ownerType;
        this.rawType = rawType;
        this.typeArguments = new Type[]{typeArgument};
    }

    private ParameterizedTypeImpl(Class<?> rawType, Type typeArgument) {
        this(null, rawType, typeArgument);
    }

    private ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type[] typeArguments) {
        this.ownerType = ownerType;
        this.rawType = rawType;
        this.typeArguments = new Type[typeArguments.length];
        System.arraycopy(typeArguments, 0, this.typeArguments, 0, this.typeArguments.length);
    }

    private ParameterizedTypeImpl(Class<?> rawType, Type[] typeArguments) {
        this(null, rawType, typeArguments);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.ownerType != null) {
            builder.append(this.ownerType instanceof Class ? ((Class)this.ownerType).getName() : this.ownerType.toString());
            builder.append('.');
        }
        builder.append(this.rawType.getName());
        builder.append('<');
        int length = this.typeArguments.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.typeArguments[i] instanceof Class ? ((Class)this.typeArguments[i]).getName() : this.typeArguments[i].toString());
        }
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int hashCode = 7;
        if (this.ownerType != null) {
            hashCode = 31 * hashCode + this.ownerType.hashCode();
        }
        hashCode = 31 * hashCode + this.rawType.hashCode();
        hashCode = 31 * hashCode + Arrays.hashCode(this.typeArguments);
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)o;
        return (this.ownerType == null ? other.getOwnerType() == null : this.ownerType.equals(other.getOwnerType())) && this.rawType.equals(other.getRawType()) && Arrays.equals(this.typeArguments, other.getActualTypeArguments());
    }
}

