/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.commons.fileupload.FileItem;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.provider.multipart.InputItem;

class InputItemImpl
implements InputItem {
    private static final Annotation[] EMPTY = new Annotation[0];
    final FileItem fileItem;
    final MultivaluedMap<String, String> headers;
    final Providers providers;

    InputItemImpl(FileItem fileItem, Providers providers) {
        this.fileItem = fileItem;
        this.providers = providers;
        this.headers = new MultivaluedMapImpl();
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public String getFilename() {
        return this.fileItem.getName();
    }

    @Override
    public MediaType getMediaType() {
        String contentType = this.fileItem.getContentType();
        return contentType == null ? null : MediaType.valueOf((String)contentType);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.fileItem.getInputStream();
    }

    @Override
    public <T> T getBody(Class<T> type, Type genericType) throws IOException {
        MediaType mediaType = this.getMediaType();
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, genericType, EMPTY, mediaType);
        if (reader == null) {
            throw new RuntimeException(String.format("Unable to find a MessageBodyReader for media type '%s' and class '%s'", mediaType, type.getName()));
        }
        return (T)reader.readFrom(type, genericType, EMPTY, mediaType, this.headers, this.getBody());
    }

    @Override
    public String getBodyAsString() throws IOException {
        return this.fileItem.getString();
    }
}

