/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;

@HandlesTypes(value={Path.class, Provider.class, Filter.class})
public class ComponentFinder
implements ServletContainerInitializer {
    private static Set<Class<?>> scanned = new LinkedHashSet();

    public static Set<Class<?>> findComponents() {
        return scanned;
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        if (c != null) {
            LinkedList<String> skip = new LinkedList<String>();
            String skipParameter = ctx.getInitParameter("org.everrest.scan.skip.packages");
            if (skipParameter != null) {
                for (String s : skipParameter.split(",")) {
                    skip.add(s.trim());
                }
            }
            skip.add("org.everrest.core");
            skip.add("javax.ws.rs");
            for (Class clazz : c) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || clazz.getEnclosingClass() != null || this.isSkipped(skip, clazz)) continue;
                scanned.add(clazz);
            }
        }
    }

    private boolean isSkipped(List<String> skip, Class<?> clazz) {
        String clazzName = clazz.getName();
        for (String s : skip) {
            if (!clazzName.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

