/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.util.ArrayList;
import java.util.List;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.ApplicationContextImpl;

public final class Tracer {
    public static boolean isTracingEnabled() {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context == null) {
            throw new IllegalStateException("ApplicationContext is not initialized yet. ");
        }
        return Boolean.parseBoolean((String)context.getQueryParameters().getFirst((Object)"tracing"));
    }

    public static void trace(String message) {
        if (Tracer.isTracingEnabled()) {
            Tracer.getTraceHolder().addTrace(message);
        }
    }

    public static void addTraceHeaders(GenericContainerResponse response) {
        if (Tracer.isTracingEnabled()) {
            Tracer.getTraceHolder().addTraceHeaders(response);
        }
    }

    private static TraceHolder getTraceHolder() {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context == null) {
            throw new IllegalStateException("ApplicationContext is not initialized yet. ");
        }
        TraceHolder t = (TraceHolder)context.getAttributes().get("tracer");
        if (t == null) {
            t = new TraceHolder();
            context.getAttributes().put("tracer", t);
        }
        return t;
    }

    private static final class TraceHolder {
        private final List<String> traces = new ArrayList<String>();

        private TraceHolder() {
        }

        void addTrace(String message) {
            this.traces.add(message);
        }

        void addTraceHeaders(GenericContainerResponse response) {
            int i = 1;
            for (String message : Tracer.getTraceHolder().traces) {
                response.getHttpHeaders().add((Object)String.format("EverRest-Trace-%03d", i++), (Object)message);
            }
        }
    }
}

