/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.everrest.core.UnhandledException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ErrorPages {
    private final Map<Integer, String> errorCodes = new HashMap<Integer, String>();
    private final Map<String, String> exceptionTypes = new HashMap<String, String>();

    public ErrorPages(ServletContext servletContext) {
        this.loadErrorPages(servletContext, this.errorCodes, this.exceptionTypes);
    }

    public boolean hasErrorPage(int errorCode) {
        return this.errorCodes.get(errorCode) != null;
    }

    public boolean hasErrorPage(String exceptionType) {
        return this.exceptionTypes.get(exceptionType) != null;
    }

    protected void loadErrorPages(ServletContext servletContext, Map<Integer, String> errorCodes, Map<String, String> exceptionTypes) throws UnhandledException {
        InputStream input = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        if (input == null) {
            return;
        }
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = documentBuilder.parse(input);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList all = (NodeList)xpath.evaluate("/web-app/error-page", dom, XPathConstants.NODESET);
            int length = all.getLength();
            for (int i = 0; i < length; ++i) {
                Element errorElement;
                NodeList locationList;
                Node errorPage = all.item(i);
                if (errorPage.getNodeType() != 1 || (locationList = (errorElement = (Element)errorPage).getElementsByTagName("location")).getLength() == 0) continue;
                String location = locationList.item(0).getTextContent();
                NodeList errorCodeList = errorElement.getElementsByTagName("error-code");
                if (errorCodeList.getLength() != 0) {
                    Integer errorCode;
                    try {
                        errorCode = Integer.valueOf(errorCodeList.item(0).getTextContent());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    errorCodes.put(errorCode, location);
                    continue;
                }
                NodeList exceptionTypeList = errorElement.getElementsByTagName("exception-type");
                if (exceptionTypeList.getLength() == 0) continue;
                exceptionTypes.put(exceptionTypeList.item(0).getTextContent(), location);
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new UnhandledException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }
}

