/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.everrest.groovy.ScriptFinder;
import org.everrest.groovy.URLFilter;

public class FileSystemScriptFinder
implements ScriptFinder {
    private static final String PROTOCOL = "file";

    @Override
    public Set<URL> find(URLFilter filter, URL root) throws MalformedURLException {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        if (PROTOCOL.equals(root.getProtocol())) {
            try {
                File file = new File(root.toURI());
                this.find(file, filter, result);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return result;
    }

    private void find(File f, URLFilter filter, Set<URL> result) throws MalformedURLException {
        for (File s : f.listFiles()) {
            if (!s.isFile()) {
                this.find(s, filter, result);
                continue;
            }
            URL url = s.toURI().toURL();
            if (!filter.accept(url)) continue;
            result.add(url);
        }
    }
}

