/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultGroovyResourceLoader
implements GroovyResourceLoader {
    private static final String DEFAULT_SOURCE_FILE_EXTENSION = ".groovy";
    protected URL[] roots;
    private int maxEntries = 256;
    protected final Map<String, URL> resources;
    final ConcurrentMap<String, FileNameLock> locks;

    public DefaultGroovyResourceLoader(URL[] roots) throws MalformedURLException {
        this.roots = new URL[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            String str = roots[i].toString();
            this.roots[i] = str.charAt(str.length() - 1) != '/' ? new URL(str + '/') : roots[i];
        }
        this.resources = Collections.synchronizedMap(new LinkedHashMap<String, URL>(this.maxEntries + 1, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, URL> eldest) {
                return this.size() > DefaultGroovyResourceLoader.this.maxEntries;
            }
        });
        this.locks = new ConcurrentHashMap<String, FileNameLock>();
    }

    public DefaultGroovyResourceLoader(URL root) throws MalformedURLException {
        this(new URL[]{root});
    }

    public final URL loadGroovySource(String filename) throws MalformedURLException {
        String[] sourceFileExtensions = this.getSourceFileExtensions();
        URL resource = null;
        filename = filename.replace('.', '/');
        for (int i = 0; i < sourceFileExtensions.length && resource == null; ++i) {
            resource = this.getResource(filename + sourceFileExtensions[i]);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String filename) throws MalformedURLException {
        FileNameLock l;
        FileNameLock lock = (FileNameLock)this.locks.get(filename);
        if (lock == null && (lock = this.locks.putIfAbsent(filename, l = new FileNameLock())) == null) {
            lock = l;
        }
        URL resource = null;
        FileNameLock fileNameLock = lock;
        synchronized (fileNameLock) {
            boolean inCache;
            resource = this.resources.get(filename);
            boolean bl = inCache = resource != null;
            if (inCache && this.checkResource(resource)) {
                return resource;
            }
            resource = null;
            for (int i = 0; i < this.roots.length && resource == null; ++i) {
                URL tmp = this.createURL(this.roots[i], filename);
                if (!this.checkResource(tmp)) continue;
                resource = tmp;
            }
            if (resource != null) {
                this.resources.put(filename, resource);
            } else if (inCache) {
                this.resources.remove(filename);
            }
        }
        return resource;
    }

    protected URL createURL(URL root, String filename) throws MalformedURLException {
        return new URL(root, filename);
    }

    protected boolean checkResource(URL resource) {
        try {
            resource.openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected String[] getSourceFileExtensions() {
        return new String[]{DEFAULT_SOURCE_FILE_EXTENSION};
    }

    @Deprecated
    protected String getSourceFileExtension() {
        return DEFAULT_SOURCE_FILE_EXTENSION;
    }

    private static final class FileNameLock {
        private static final AtomicInteger counter = new AtomicInteger();
        private final int hash = counter.incrementAndGet();

        private FileNameLock() {
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hash == ((FileNameLock)obj).hash;
        }
    }
}

