/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import org.everrest.groovy.ScriptFinder;
import org.everrest.groovy.URLFilter;

public class FileSystemScriptFinder
implements ScriptFinder {
    @Override
    public URL[] find(URLFilter filter, URL root) throws MalformedURLException {
        File file;
        if ("file".equals(root.getProtocol()) && (file = new File(URI.create(root.toString()))).isDirectory()) {
            return this.find(file, filter);
        }
        return new URL[0];
    }

    private URL[] find(File directory, URLFilter filter) throws MalformedURLException {
        ArrayList<URL> files = new ArrayList<URL>();
        LinkedList<File> q = new LinkedList<File>();
        q.add(directory);
        while (!q.isEmpty()) {
            File current = (File)q.pop();
            File[] list = current.listFiles();
            if (list == null) continue;
            for (int i = 0; i < list.length; ++i) {
                File f = list[i];
                if (f.isDirectory()) {
                    q.push(f);
                    continue;
                }
                URL url = f.toURI().toURL();
                if (!filter.accept(url)) continue;
                files.add(url);
            }
        }
        return files.toArray(new URL[files.size()]);
    }
}

