/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import org.everrest.core.util.Logger;
import org.everrest.http.client.AuthSchemeNotImplException;
import org.everrest.http.client.AuthorizationHandler;
import org.everrest.http.client.AuthorizationInfo;
import org.everrest.http.client.HTTPClientModule;
import org.everrest.http.client.HTTPConnection;
import org.everrest.http.client.HttpOutputStream;
import org.everrest.http.client.NVPair;
import org.everrest.http.client.Request;
import org.everrest.http.client.Response;
import org.everrest.http.client.RoRequest;
import org.everrest.http.client.RoResponse;
import org.everrest.http.client.Util;

class AuthorizationModule
implements HTTPClientModule {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private static Hashtable deferred_auth_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private Request saved_req = null;
    private Response saved_resp = null;
    private static final Logger log = Logger.getLogger(AuthorizationModule.class);

    AuthorizationModule() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) throws IOException, AuthSchemeNotImplException {
        int rem_idx;
        NVPair[] hdrs;
        block27: {
            AuthorizationInfo guess;
            block29: {
                AuthorizationHandler auth_handler;
                block26: {
                    block28: {
                        Hashtable proxy_auth_list;
                        HTTPConnection con = req.getConnection();
                        auth_handler = AuthorizationInfo.getAuthHandler();
                        hdrs = req.getHeaders();
                        rem_idx = -1;
                        HttpOutputStream out = req.getStream();
                        if (out != null && deferred_auth_list.get(out) != null) {
                            this.copyFrom((AuthorizationModule)deferred_auth_list.remove(out));
                            req.copyFrom(this.saved_req);
                            if (log.isDebugEnabled()) {
                                log.debug("Handling deferred auth challenge");
                            }
                            this.handle_auth_challenge(req, this.saved_resp);
                            if (this.auth_sent != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Sending request with Authorization '" + this.auth_sent + "'");
                                }
                            } else if (log.isDebugEnabled()) {
                                log.debug("Sending request with Proxy-Authorization '" + this.prxy_sent + "'");
                            }
                            return 1;
                        }
                        if (con.getProxyHost() == null || this.prxy_from_4xx) break block26;
                        for (int idx = 0; idx < hdrs.length; ++idx) {
                            if (!hdrs[idx].getName().equalsIgnoreCase("Proxy-Authorization")) continue;
                            rem_idx = idx;
                            break;
                        }
                        if ((guess = (AuthorizationInfo)(proxy_auth_list = Util.getList(proxy_cntxt_list, con.getContext())).get(con.getProxyHost() + ":" + con.getProxyPort())) == null) break block26;
                        if (auth_handler == null) break block28;
                        try {
                            guess = auth_handler.fixupAuthInfo(guess, req, null, null);
                        }
                        catch (AuthSchemeNotImplException asnie) {
                            break block26;
                        }
                        if (guess == null) break block26;
                    }
                    if (rem_idx == -1) {
                        rem_idx = hdrs.length;
                        hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                        req.setHeaders(hdrs);
                    }
                    hdrs[rem_idx] = new NVPair("Proxy-Authorization", guess.toString());
                    rem_idx = -1;
                    this.prxy_sent = guess;
                    this.prxy_from_4xx = false;
                    if (log.isDebugEnabled()) {
                        log.debug("Preemptively sending Proxy-Authorization '" + guess + "'");
                    }
                }
                if (rem_idx >= 0) {
                    System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
                    hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
                    req.setHeaders(hdrs);
                }
                rem_idx = -1;
                if (this.auth_from_4xx) break block27;
                for (int idx = 0; idx < hdrs.length; ++idx) {
                    if (!hdrs[idx].getName().equalsIgnoreCase("Authorization")) continue;
                    rem_idx = idx;
                    break;
                }
                if ((guess = AuthorizationInfo.findBest(req)) == null) break block27;
                if (auth_handler == null) break block29;
                try {
                    guess = auth_handler.fixupAuthInfo(guess, req, null, null);
                }
                catch (AuthSchemeNotImplException asnie) {
                    break block27;
                }
                if (guess == null) break block27;
            }
            if (rem_idx == -1) {
                rem_idx = hdrs.length;
                hdrs = Util.resizeArray(hdrs, rem_idx + 1);
                req.setHeaders(hdrs);
            }
            hdrs[rem_idx] = new NVPair("Authorization", guess.toString());
            rem_idx = -1;
            this.auth_sent = guess;
            this.auth_from_4xx = false;
            if (log.isDebugEnabled()) {
                log.debug("Preemptively sending Authorization '" + guess + "'");
            }
        }
        if (rem_idx >= 0) {
            System.arraycopy(hdrs, rem_idx + 1, hdrs, rem_idx, hdrs.length - rem_idx - 1);
            hdrs = Util.resizeArray(hdrs, hdrs.length - 1);
            req.setHeaders(hdrs);
        }
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        if (resp.getStatusCode() != 401 && resp.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, req, resp, false).addPath(req.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
        if (resp.getHeader("WWW-Authenticate") == null) {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        if (resp.getHeader("Proxy-Authenticate") == null) {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthHeaders(resp, req, this.auth_sent, this.prxy_sent);
        }
        int sts = resp.getStatusCode();
        switch (sts) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (req.getStream() != null) {
                    if (!HTTPConnection.deferStreamed) {
                        if (log.isDebugEnabled()) {
                            log.debug("Status " + sts + " not handled - request has an output stream");
                        }
                        return 10;
                    }
                    this.saved_req = (Request)req.clone();
                    this.saved_resp = (Response)resp.clone();
                    deferred_auth_list.put(req.getStream(), this);
                    req.getStream().reset();
                    resp.setRetryRequest(true);
                    if (log.isDebugEnabled()) {
                        log.debug("Handling of status " + sts + " deferred because an output stream was used");
                    }
                    return 10;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Handling status: " + sts + " " + resp.getReasonLine());
                }
                this.handle_auth_challenge(req, resp);
                if (this.auth_sent != null || this.prxy_sent != null) {
                    try {
                        resp.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (this.auth_sent != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Resending request with Authorization '" + this.auth_sent + "'");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Resending request with Proxy-Authorization '" + this.prxy_sent + "'");
                    }
                    return 13;
                }
                if (req.getStream() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Status " + sts + " not handled - request has an output stream");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("No Auth Info found - status " + sts + " not handled");
                }
                return 10;
            }
        }
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthTrailers(resp, req, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request req, Response resp) throws AuthSchemeNotImplException, IOException {
        int[] idx_arr = new int[]{this.auth_lst_idx, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(resp.getHeader("WWW-Authenticate"), req, resp, "Authorization", idx_arr, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
            this.auth_lst_idx = idx_arr[0];
            this.auth_scm_idx = idx_arr[1];
        } else {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        idx_arr[0] = this.prxy_lst_idx;
        idx_arr[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(resp.getHeader("Proxy-Authenticate"), req, resp, "Proxy-Authorization", idx_arr, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
            this.prxy_lst_idx = idx_arr[0];
            this.prxy_scm_idx = idx_arr[1];
        } else {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
        if (this.prxy_sent != null) {
            HTTPConnection con = req.getConnection();
            Util.getList(proxy_cntxt_list, con.getContext()).put(con.getProxyHost() + ":" + con.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && resp.getHeader("WWW-Authenticate") == null && resp.getHeader("Proxy-Authenticate") == null) {
            if (resp.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
            throw new ProtocolException("Missing Proxy-Authenticate header");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationInfo setAuthHeaders(String auth_str, Request req, RoResponse resp, String header, int[] idx_arr, AuthorizationInfo prev) throws ProtocolException, AuthSchemeNotImplException, IOException {
        int auth_idx;
        int idx;
        if (auth_str == null) {
            return null;
        }
        AuthorizationInfo[] challenges = AuthorizationInfo.parseAuthString(auth_str, req, resp);
        if (log.isDebugEnabled()) {
            log.debug("Parsed " + challenges.length + " challenges:");
            for (idx = 0; idx < challenges.length; ++idx) {
                log.debug("AuthM: Challenge " + challenges[idx]);
            }
        }
        if (challenges.length == 0) {
            return null;
        }
        if (prev != null && prev.getScheme().equalsIgnoreCase("Basic")) {
            for (idx = 0; idx < challenges.length; ++idx) {
                if (!prev.getRealm().equals(challenges[idx].getRealm()) || !prev.getScheme().equalsIgnoreCase(challenges[idx].getScheme())) continue;
                AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
            }
        }
        AuthorizationInfo credentials = null;
        AuthorizationHandler auth_handler = AuthorizationInfo.getAuthHandler();
        while (credentials == null && idx_arr[0] != -1 && idx_arr[0] < challenges.length) {
            credentials = AuthorizationInfo.getAuthorization(challenges[idx_arr[0]], req, resp, false);
            if (auth_handler != null && credentials != null) {
                credentials = auth_handler.fixupAuthInfo(credentials, req, challenges[idx_arr[0]], resp);
            }
            if ((idx_arr[0] = idx_arr[0] + 1) != challenges.length) continue;
            idx_arr[0] = -1;
        }
        if (credentials == null) {
            for (int idx2 = 0; idx2 < challenges.length; ++idx2) {
                if (idx_arr[1] >= challenges.length) {
                    idx_arr[1] = 0;
                }
                try {
                    credentials = AuthorizationInfo.queryAuthHandler(challenges[idx_arr[1]], req, resp);
                    break;
                }
                catch (AuthSchemeNotImplException asnie) {
                    if (idx2 != challenges.length - 1) continue;
                    throw asnie;
                }
                finally {
                    idx_arr[1] = idx_arr[1] + 1;
                }
            }
        }
        if (credentials == null) {
            return null;
        }
        NVPair[] hdrs = req.getHeaders();
        for (auth_idx = 0; auth_idx < hdrs.length && !hdrs[auth_idx].getName().equalsIgnoreCase(header); ++auth_idx) {
        }
        if (auth_idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, auth_idx + 1);
            req.setHeaders(hdrs);
        }
        hdrs[auth_idx] = new NVPair(header, credentials.toString());
        return credentials;
    }

    private void copyFrom(AuthorizationModule other) {
        this.auth_lst_idx = other.auth_lst_idx;
        this.prxy_lst_idx = other.prxy_lst_idx;
        this.auth_scm_idx = other.auth_scm_idx;
        this.prxy_scm_idx = other.prxy_scm_idx;
        this.auth_sent = other.auth_sent;
        this.prxy_sent = other.prxy_sent;
        this.auth_from_4xx = other.auth_from_4xx;
        this.prxy_from_4xx = other.prxy_from_4xx;
        this.num_tries = other.num_tries;
        this.saved_req = other.saved_req;
        this.saved_resp = other.saved_resp;
    }
}

