/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.http.client;

import java.io.IOException;
import org.everrest.core.util.Logger;
import org.everrest.http.client.HTTPClientModule;
import org.everrest.http.client.MD5InputStream;
import org.everrest.http.client.ModuleException;
import org.everrest.http.client.ParseException;
import org.everrest.http.client.Request;
import org.everrest.http.client.Response;
import org.everrest.http.client.RoRequest;
import org.everrest.http.client.Util;
import org.everrest.http.client.VerifyMD5;

class ContentMD5Module
implements HTTPClientModule {
    private static final Logger log = Logger.getLogger(ContentMD5Module.class);

    ContentMD5Module() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        if (req.getMethod().equals("HEAD")) {
            return;
        }
        String md5_digest = resp.getHeader("Content-MD5");
        String trailer = resp.getHeader("Trailer");
        boolean md5_tok = false;
        try {
            if (trailer != null) {
                md5_tok = Util.hasToken(trailer, "Content-MD5");
            }
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (md5_digest == null && !md5_tok || resp.getHeader("Transfer-Encoding") != null) {
            return;
        }
        if (log.isDebugEnabled()) {
            if (md5_digest != null) {
                log.debug("Received digest: " + md5_digest + " - pushing md5-check-stream");
            } else {
                log.debug("Expecting digest in trailer  - pushing md5-check-stream");
            }
        }
        resp.inp_stream = new MD5InputStream(resp.inp_stream, new VerifyMD5(resp));
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) {
    }
}

